"use strict";
// https://www.terraform.io/docs/providers/aws/r/api_gateway_domain_name.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayDomainName = void 0;
const cdktf_1 = require("cdktf");
// Resource
class ApiGatewayDomainName extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_api_gateway_domain_name',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._certificateArn = config.certificateArn;
        this._certificateBody = config.certificateBody;
        this._certificateChain = config.certificateChain;
        this._certificateName = config.certificateName;
        this._certificatePrivateKey = config.certificatePrivateKey;
        this._domainName = config.domainName;
        this._regionalCertificateArn = config.regionalCertificateArn;
        this._regionalCertificateName = config.regionalCertificateName;
        this._securityPolicy = config.securityPolicy;
        this._tags = config.tags;
        this._endpointConfiguration = config.endpointConfiguration;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get certificateArn() {
        return this._certificateArn;
    }
    set certificateArn(value) {
        this._certificateArn = value;
    }
    get certificateBody() {
        return this._certificateBody;
    }
    set certificateBody(value) {
        this._certificateBody = value;
    }
    get certificateChain() {
        return this._certificateChain;
    }
    set certificateChain(value) {
        this._certificateChain = value;
    }
    get certificateName() {
        return this._certificateName;
    }
    set certificateName(value) {
        this._certificateName = value;
    }
    get certificatePrivateKey() {
        return this._certificatePrivateKey;
    }
    set certificatePrivateKey(value) {
        this._certificatePrivateKey = value;
    }
    // certificate_upload_date - computed: true, optional: false, required: true
    get certificateUploadDate() {
        return this.getStringAttribute('certificate_upload_date');
    }
    // cloudfront_domain_name - computed: true, optional: false, required: true
    get cloudfrontDomainName() {
        return this.getStringAttribute('cloudfront_domain_name');
    }
    // cloudfront_zone_id - computed: true, optional: false, required: true
    get cloudfrontZoneId() {
        return this.getStringAttribute('cloudfront_zone_id');
    }
    get domainName() {
        return this._domainName;
    }
    set domainName(value) {
        this._domainName = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get regionalCertificateArn() {
        return this._regionalCertificateArn;
    }
    set regionalCertificateArn(value) {
        this._regionalCertificateArn = value;
    }
    get regionalCertificateName() {
        return this._regionalCertificateName;
    }
    set regionalCertificateName(value) {
        this._regionalCertificateName = value;
    }
    // regional_domain_name - computed: true, optional: false, required: true
    get regionalDomainName() {
        return this.getStringAttribute('regional_domain_name');
    }
    // regional_zone_id - computed: true, optional: false, required: true
    get regionalZoneId() {
        return this.getStringAttribute('regional_zone_id');
    }
    get securityPolicy() {
        var _a;
        return (_a = this._securityPolicy) !== null && _a !== void 0 ? _a : this.getStringAttribute('security_policy');
    }
    set securityPolicy(value) {
        this._securityPolicy = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get endpointConfiguration() {
        return this._endpointConfiguration;
    }
    set endpointConfiguration(value) {
        this._endpointConfiguration = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            certificate_arn: this._certificateArn,
            certificate_body: this._certificateBody,
            certificate_chain: this._certificateChain,
            certificate_name: this._certificateName,
            certificate_private_key: this._certificatePrivateKey,
            domain_name: this._domainName,
            regional_certificate_arn: this._regionalCertificateArn,
            regional_certificate_name: this._regionalCertificateName,
            security_policy: this._securityPolicy,
            tags: this._tags,
            endpoint_configuration: this._endpointConfiguration,
        };
    }
}
exports.ApiGatewayDomainName = ApiGatewayDomainName;
//# sourceMappingURL=data:application/json;base64,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