import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayIntegrationResponseConfig extends TerraformMetaArguments {
    readonly contentHandling?: string;
    readonly httpMethod: string;
    readonly resourceId: string;
    readonly responseParameters?: {
        [key: string]: string;
    };
    readonly responseParametersInJson?: string;
    readonly responseTemplates?: {
        [key: string]: string;
    };
    readonly restApiId: string;
    readonly selectionPattern?: string;
    readonly statusCode: string;
}
export declare class ApiGatewayIntegrationResponse extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayIntegrationResponseConfig);
    private _contentHandling?;
    get contentHandling(): string | undefined;
    set contentHandling(value: string | undefined);
    private _httpMethod;
    get httpMethod(): string;
    set httpMethod(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _resourceId;
    get resourceId(): string;
    set resourceId(value: string);
    private _responseParameters?;
    get responseParameters(): {
        [key: string]: string;
    } | undefined;
    set responseParameters(value: {
        [key: string]: string;
    } | undefined);
    private _responseParametersInJson?;
    get responseParametersInJson(): string | undefined;
    set responseParametersInJson(value: string | undefined);
    private _responseTemplates?;
    get responseTemplates(): {
        [key: string]: string;
    } | undefined;
    set responseTemplates(value: {
        [key: string]: string;
    } | undefined);
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    private _selectionPattern?;
    get selectionPattern(): string | undefined;
    set selectionPattern(value: string | undefined);
    private _statusCode;
    get statusCode(): string;
    set statusCode(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
