import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayIntegrationConfig extends TerraformMetaArguments {
    readonly cacheKeyParameters?: string[];
    readonly cacheNamespace?: string;
    readonly connectionId?: string;
    readonly connectionType?: string;
    readonly contentHandling?: string;
    readonly credentials?: string;
    readonly httpMethod: string;
    readonly integrationHttpMethod?: string;
    readonly passthroughBehavior?: string;
    readonly requestParameters?: {
        [key: string]: string;
    };
    readonly requestParametersInJson?: string;
    readonly requestTemplates?: {
        [key: string]: string;
    };
    readonly resourceId: string;
    readonly restApiId: string;
    readonly timeoutMilliseconds?: number;
    readonly type: string;
    readonly uri?: string;
}
export declare class ApiGatewayIntegration extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayIntegrationConfig);
    private _cacheKeyParameters?;
    get cacheKeyParameters(): string[] | undefined;
    set cacheKeyParameters(value: string[] | undefined);
    private _cacheNamespace?;
    get cacheNamespace(): string | undefined;
    set cacheNamespace(value: string | undefined);
    private _connectionId?;
    get connectionId(): string | undefined;
    set connectionId(value: string | undefined);
    private _connectionType?;
    get connectionType(): string | undefined;
    set connectionType(value: string | undefined);
    private _contentHandling?;
    get contentHandling(): string | undefined;
    set contentHandling(value: string | undefined);
    private _credentials?;
    get credentials(): string | undefined;
    set credentials(value: string | undefined);
    private _httpMethod;
    get httpMethod(): string;
    set httpMethod(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _integrationHttpMethod?;
    get integrationHttpMethod(): string | undefined;
    set integrationHttpMethod(value: string | undefined);
    private _passthroughBehavior?;
    get passthroughBehavior(): string | undefined;
    set passthroughBehavior(value: string | undefined);
    private _requestParameters?;
    get requestParameters(): {
        [key: string]: string;
    } | undefined;
    set requestParameters(value: {
        [key: string]: string;
    } | undefined);
    private _requestParametersInJson?;
    get requestParametersInJson(): string | undefined;
    set requestParametersInJson(value: string | undefined);
    private _requestTemplates?;
    get requestTemplates(): {
        [key: string]: string;
    } | undefined;
    set requestTemplates(value: {
        [key: string]: string;
    } | undefined);
    private _resourceId;
    get resourceId(): string;
    set resourceId(value: string);
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    private _timeoutMilliseconds?;
    get timeoutMilliseconds(): number | undefined;
    set timeoutMilliseconds(value: number | undefined);
    private _type;
    get type(): string;
    set type(value: string);
    private _uri?;
    get uri(): string | undefined;
    set uri(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
