import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayMethodResponseConfig extends TerraformMetaArguments {
    readonly httpMethod: string;
    readonly resourceId: string;
    readonly responseModels?: {
        [key: string]: string;
    };
    readonly responseParameters?: {
        [key: string]: boolean;
    };
    readonly responseParametersInJson?: string;
    readonly restApiId: string;
    readonly statusCode: string;
}
export declare class ApiGatewayMethodResponse extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayMethodResponseConfig);
    private _httpMethod;
    get httpMethod(): string;
    set httpMethod(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _resourceId;
    get resourceId(): string;
    set resourceId(value: string);
    private _responseModels?;
    get responseModels(): {
        [key: string]: string;
    } | undefined;
    set responseModels(value: {
        [key: string]: string;
    } | undefined);
    private _responseParameters?;
    get responseParameters(): {
        [key: string]: boolean;
    } | undefined;
    set responseParameters(value: {
        [key: string]: boolean;
    } | undefined);
    private _responseParametersInJson?;
    get responseParametersInJson(): string | undefined;
    set responseParametersInJson(value: string | undefined);
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    private _statusCode;
    get statusCode(): string;
    set statusCode(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
