import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayMethodSettingsConfig extends TerraformMetaArguments {
    readonly methodPath: string;
    readonly restApiId: string;
    readonly stageName: string;
    /** settings block */
    readonly settings: ApiGatewayMethodSettingsSettings[];
}
export interface ApiGatewayMethodSettingsSettings {
    readonly cacheDataEncrypted?: boolean;
    readonly cacheTtlInSeconds?: number;
    readonly cachingEnabled?: boolean;
    readonly dataTraceEnabled?: boolean;
    readonly loggingLevel?: string;
    readonly metricsEnabled?: boolean;
    readonly requireAuthorizationForCacheControl?: boolean;
    readonly throttlingBurstLimit?: number;
    readonly throttlingRateLimit?: number;
    readonly unauthorizedCacheControlHeaderStrategy?: string;
}
export declare class ApiGatewayMethodSettings extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayMethodSettingsConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _methodPath;
    get methodPath(): string;
    set methodPath(value: string);
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    private _stageName;
    get stageName(): string;
    set stageName(value: string);
    private _settings;
    get settings(): ApiGatewayMethodSettingsSettings[];
    set settings(value: ApiGatewayMethodSettingsSettings[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
