import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayMethodConfig extends TerraformMetaArguments {
    readonly apiKeyRequired?: boolean;
    readonly authorization: string;
    readonly authorizationScopes?: string[];
    readonly authorizerId?: string;
    readonly httpMethod: string;
    readonly requestModels?: {
        [key: string]: string;
    };
    readonly requestParameters?: {
        [key: string]: boolean;
    };
    readonly requestParametersInJson?: string;
    readonly requestValidatorId?: string;
    readonly resourceId: string;
    readonly restApiId: string;
}
export declare class ApiGatewayMethod extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayMethodConfig);
    private _apiKeyRequired?;
    get apiKeyRequired(): boolean | undefined;
    set apiKeyRequired(value: boolean | undefined);
    private _authorization;
    get authorization(): string;
    set authorization(value: string);
    private _authorizationScopes?;
    get authorizationScopes(): string[] | undefined;
    set authorizationScopes(value: string[] | undefined);
    private _authorizerId?;
    get authorizerId(): string | undefined;
    set authorizerId(value: string | undefined);
    private _httpMethod;
    get httpMethod(): string;
    set httpMethod(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _requestModels?;
    get requestModels(): {
        [key: string]: string;
    } | undefined;
    set requestModels(value: {
        [key: string]: string;
    } | undefined);
    private _requestParameters?;
    get requestParameters(): {
        [key: string]: boolean;
    } | undefined;
    set requestParameters(value: {
        [key: string]: boolean;
    } | undefined);
    private _requestParametersInJson?;
    get requestParametersInJson(): string | undefined;
    set requestParametersInJson(value: string | undefined);
    private _requestValidatorId?;
    get requestValidatorId(): string | undefined;
    set requestValidatorId(value: string | undefined);
    private _resourceId;
    get resourceId(): string;
    set resourceId(value: string);
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
