"use strict";
// https://www.terraform.io/docs/providers/aws/r/api_gateway_method.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayMethod = void 0;
const cdktf_1 = require("cdktf");
// Resource
class ApiGatewayMethod extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_api_gateway_method',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._apiKeyRequired = config.apiKeyRequired;
        this._authorization = config.authorization;
        this._authorizationScopes = config.authorizationScopes;
        this._authorizerId = config.authorizerId;
        this._httpMethod = config.httpMethod;
        this._requestModels = config.requestModels;
        this._requestParameters = config.requestParameters;
        this._requestParametersInJson = config.requestParametersInJson;
        this._requestValidatorId = config.requestValidatorId;
        this._resourceId = config.resourceId;
        this._restApiId = config.restApiId;
    }
    get apiKeyRequired() {
        return this._apiKeyRequired;
    }
    set apiKeyRequired(value) {
        this._apiKeyRequired = value;
    }
    get authorization() {
        return this._authorization;
    }
    set authorization(value) {
        this._authorization = value;
    }
    get authorizationScopes() {
        return this._authorizationScopes;
    }
    set authorizationScopes(value) {
        this._authorizationScopes = value;
    }
    get authorizerId() {
        return this._authorizerId;
    }
    set authorizerId(value) {
        this._authorizerId = value;
    }
    get httpMethod() {
        return this._httpMethod;
    }
    set httpMethod(value) {
        this._httpMethod = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get requestModels() {
        return this._requestModels;
    }
    set requestModels(value) {
        this._requestModels = value;
    }
    get requestParameters() {
        return this._requestParameters;
    }
    set requestParameters(value) {
        this._requestParameters = value;
    }
    get requestParametersInJson() {
        return this._requestParametersInJson;
    }
    set requestParametersInJson(value) {
        this._requestParametersInJson = value;
    }
    get requestValidatorId() {
        return this._requestValidatorId;
    }
    set requestValidatorId(value) {
        this._requestValidatorId = value;
    }
    get resourceId() {
        return this._resourceId;
    }
    set resourceId(value) {
        this._resourceId = value;
    }
    get restApiId() {
        return this._restApiId;
    }
    set restApiId(value) {
        this._restApiId = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            api_key_required: this._apiKeyRequired,
            authorization: this._authorization,
            authorization_scopes: this._authorizationScopes,
            authorizer_id: this._authorizerId,
            http_method: this._httpMethod,
            request_models: this._requestModels,
            request_parameters: this._requestParameters,
            request_parameters_in_json: this._requestParametersInJson,
            request_validator_id: this._requestValidatorId,
            resource_id: this._resourceId,
            rest_api_id: this._restApiId,
        };
    }
}
exports.ApiGatewayMethod = ApiGatewayMethod;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLWdhdGV3YXktbWV0aG9kLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2FwaS1nYXRld2F5LW1ldGhvZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsd0VBQXdFO0FBQ3hFLDJDQUEyQzs7O0FBc0UzQyxpQ0FBMEM7QUFtQjFDLFdBQVc7QUFFWCxNQUFhLGdCQUFpQixTQUFRLHlCQUFpQjtJQUVyRCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZCxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUE4QjtRQUM3RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLHdCQUF3QjtZQUMvQywwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLEtBQUs7YUFDcEI7WUFDRCxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDekIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztZQUNuQixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7U0FDNUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzdDLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztRQUN6QyxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxNQUFNLENBQUMsaUJBQWlCLENBQUM7UUFDbkQsSUFBSSxDQUFDLHdCQUF3QixHQUFHLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQztRQUMvRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7SUFDckMsQ0FBQztJQVFELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQTBCO1FBQ2xELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUEyQjtRQUN4RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUF5QjtRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxFQUFFOztRQUNYLGFBQU8sSUFBSSxDQUFDLEdBQUcsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLEVBQUUsQ0FBQyxLQUF5QjtRQUNyQyxJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQztJQUNuQixDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBNEM7UUFDbkUsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQTZDO1FBQ3hFLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLHdCQUF3QixDQUFDO0lBQ3ZDLENBQUM7SUFDRCxJQUFXLHVCQUF1QixDQUFDLEtBQXlCO1FBQzFELElBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUM7SUFDeEMsQ0FBQztJQUlELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFDRCxJQUFXLGtCQUFrQixDQUFDLEtBQXlCO1FBQ3JELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWE7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQWE7UUFDaEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVMLG9CQUFvQjtRQUN6QixPQUFPO1lBQ0wsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDdEMsYUFBYSxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ2xDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQywwQkFBMEIsRUFBRSxJQUFJLENBQUMsd0JBQXdCO1lBQ3pELG9CQUFvQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDOUMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLFdBQVcsRUFBRSxJQUFJLENBQUMsVUFBVTtTQUM3QixDQUFDO0lBQ0osQ0FBQztDQUNGO0FBaktELDRDQWlLQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9hd3Mvci9hcGlfZ2F0ZXdheV9tZXRob2QuaHRtbFxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG4vKlxue1xuICBcInZlcnNpb25cIjogMCxcbiAgXCJibG9ja1wiOiB7XG4gICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgIFwiYXBpX2tleV9yZXF1aXJlZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJhdXRob3JpemF0aW9uXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiYXV0aG9yaXphdGlvbl9zY29wZXNcIjoge1xuICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICBdLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImF1dGhvcml6ZXJfaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJodHRwX21ldGhvZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImlkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJyZXF1ZXN0X21vZGVsc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgXCJtYXBcIixcbiAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicmVxdWVzdF9wYXJhbWV0ZXJzXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICBcIm1hcFwiLFxuICAgICAgICAgIFwiYm9vbFwiXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicmVxdWVzdF9wYXJhbWV0ZXJzX2luX2pzb25cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJyZXF1ZXN0X3ZhbGlkYXRvcl9pZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInJlc291cmNlX2lkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicmVzdF9hcGlfaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICB9XG4gICAgfVxuICB9XG59XG4qL1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBUZXJyYWZvcm1SZXNvdXJjZSB9IGZyb20gJ2Nka3RmJztcbmltcG9ydCB7IFRlcnJhZm9ybU1ldGFBcmd1bWVudHMgfSBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBBcGlHYXRld2F5TWV0aG9kQ29uZmlnIGV4dGVuZHMgVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIHJlYWRvbmx5IGFwaUtleVJlcXVpcmVkPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgYXV0aG9yaXphdGlvbjogc3RyaW5nO1xuICByZWFkb25seSBhdXRob3JpemF0aW9uU2NvcGVzPzogc3RyaW5nW107XG4gIHJlYWRvbmx5IGF1dGhvcml6ZXJJZD86IHN0cmluZztcbiAgcmVhZG9ubHkgaHR0cE1ldGhvZDogc3RyaW5nO1xuICByZWFkb25seSByZXF1ZXN0TW9kZWxzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbiAgcmVhZG9ubHkgcmVxdWVzdFBhcmFtZXRlcnM/OiB7IFtrZXk6IHN0cmluZ106IGJvb2xlYW4gfTtcbiAgcmVhZG9ubHkgcmVxdWVzdFBhcmFtZXRlcnNJbkpzb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlcXVlc3RWYWxpZGF0b3JJZD86IHN0cmluZztcbiAgcmVhZG9ubHkgcmVzb3VyY2VJZDogc3RyaW5nO1xuICByZWFkb25seSByZXN0QXBpSWQ6IHN0cmluZztcbn1cblxuLy8gUmVzb3VyY2VcblxuZXhwb3J0IGNsYXNzIEFwaUdhdGV3YXlNZXRob2QgZXh0ZW5kcyBUZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBBcGlHYXRld2F5TWV0aG9kQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3NfYXBpX2dhdGV3YXlfbWV0aG9kJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F3cydcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX2FwaUtleVJlcXVpcmVkID0gY29uZmlnLmFwaUtleVJlcXVpcmVkO1xuICAgIHRoaXMuX2F1dGhvcml6YXRpb24gPSBjb25maWcuYXV0aG9yaXphdGlvbjtcbiAgICB0aGlzLl9hdXRob3JpemF0aW9uU2NvcGVzID0gY29uZmlnLmF1dGhvcml6YXRpb25TY29wZXM7XG4gICAgdGhpcy5fYXV0aG9yaXplcklkID0gY29uZmlnLmF1dGhvcml6ZXJJZDtcbiAgICB0aGlzLl9odHRwTWV0aG9kID0gY29uZmlnLmh0dHBNZXRob2Q7XG4gICAgdGhpcy5fcmVxdWVzdE1vZGVscyA9IGNvbmZpZy5yZXF1ZXN0TW9kZWxzO1xuICAgIHRoaXMuX3JlcXVlc3RQYXJhbWV0ZXJzID0gY29uZmlnLnJlcXVlc3RQYXJhbWV0ZXJzO1xuICAgIHRoaXMuX3JlcXVlc3RQYXJhbWV0ZXJzSW5Kc29uID0gY29uZmlnLnJlcXVlc3RQYXJhbWV0ZXJzSW5Kc29uO1xuICAgIHRoaXMuX3JlcXVlc3RWYWxpZGF0b3JJZCA9IGNvbmZpZy5yZXF1ZXN0VmFsaWRhdG9ySWQ7XG4gICAgdGhpcy5fcmVzb3VyY2VJZCA9IGNvbmZpZy5yZXNvdXJjZUlkO1xuICAgIHRoaXMuX3Jlc3RBcGlJZCA9IGNvbmZpZy5yZXN0QXBpSWQ7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGFwaV9rZXlfcmVxdWlyZWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYXBpS2V5UmVxdWlyZWQ/OiBib29sZWFuO1xuICBwdWJsaWMgZ2V0IGFwaUtleVJlcXVpcmVkKCkge1xuICAgIHJldHVybiB0aGlzLl9hcGlLZXlSZXF1aXJlZDtcbiAgfVxuICBwdWJsaWMgc2V0IGFwaUtleVJlcXVpcmVkKHZhbHVlOiBib29sZWFuIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYXBpS2V5UmVxdWlyZWQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGF1dGhvcml6YXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfYXV0aG9yaXphdGlvbjogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGF1dGhvcml6YXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2F1dGhvcml6YXRpb247XG4gIH1cbiAgcHVibGljIHNldCBhdXRob3JpemF0aW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9hdXRob3JpemF0aW9uID0gdmFsdWU7XG4gIH1cblxuICAvLyBhdXRob3JpemF0aW9uX3Njb3BlcyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hdXRob3JpemF0aW9uU2NvcGVzPzogc3RyaW5nW107XG4gIHB1YmxpYyBnZXQgYXV0aG9yaXphdGlvblNjb3BlcygpIHtcbiAgICByZXR1cm4gdGhpcy5fYXV0aG9yaXphdGlvblNjb3BlcztcbiAgfVxuICBwdWJsaWMgc2V0IGF1dGhvcml6YXRpb25TY29wZXModmFsdWU6IHN0cmluZ1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYXV0aG9yaXphdGlvblNjb3BlcyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gYXV0aG9yaXplcl9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hdXRob3JpemVySWQ/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgYXV0aG9yaXplcklkKCkge1xuICAgIHJldHVybiB0aGlzLl9hdXRob3JpemVySWQ7XG4gIH1cbiAgcHVibGljIHNldCBhdXRob3JpemVySWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2F1dGhvcml6ZXJJZCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gaHR0cF9tZXRob2QgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfaHR0cE1ldGhvZDogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGh0dHBNZXRob2QoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2h0dHBNZXRob2Q7XG4gIH1cbiAgcHVibGljIHNldCBodHRwTWV0aG9kKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9odHRwTWV0aG9kID0gdmFsdWU7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGlkKCkge1xuICAgIHJldHVybiB0aGlzLl9pZCA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlkKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9pZCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gcmVxdWVzdF9tb2RlbHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVxdWVzdE1vZGVscz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG4gIHB1YmxpYyBnZXQgcmVxdWVzdE1vZGVscygpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVxdWVzdE1vZGVscztcbiAgfVxuICBwdWJsaWMgc2V0IHJlcXVlc3RNb2RlbHModmFsdWU6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9yZXF1ZXN0TW9kZWxzID0gdmFsdWU7XG4gIH1cblxuICAvLyByZXF1ZXN0X3BhcmFtZXRlcnMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVxdWVzdFBhcmFtZXRlcnM/OiB7IFtrZXk6IHN0cmluZ106IGJvb2xlYW4gfTtcbiAgcHVibGljIGdldCByZXF1ZXN0UGFyYW1ldGVycygpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVxdWVzdFBhcmFtZXRlcnM7XG4gIH1cbiAgcHVibGljIHNldCByZXF1ZXN0UGFyYW1ldGVycyh2YWx1ZTogeyBba2V5OiBzdHJpbmddOiBib29sZWFuIH0gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9yZXF1ZXN0UGFyYW1ldGVycyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gcmVxdWVzdF9wYXJhbWV0ZXJzX2luX2pzb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVxdWVzdFBhcmFtZXRlcnNJbkpzb24/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgcmVxdWVzdFBhcmFtZXRlcnNJbkpzb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcXVlc3RQYXJhbWV0ZXJzSW5Kc29uO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVxdWVzdFBhcmFtZXRlcnNJbkpzb24odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3JlcXVlc3RQYXJhbWV0ZXJzSW5Kc29uID0gdmFsdWU7XG4gIH1cblxuICAvLyByZXF1ZXN0X3ZhbGlkYXRvcl9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZXF1ZXN0VmFsaWRhdG9ySWQ/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgcmVxdWVzdFZhbGlkYXRvcklkKCkge1xuICAgIHJldHVybiB0aGlzLl9yZXF1ZXN0VmFsaWRhdG9ySWQ7XG4gIH1cbiAgcHVibGljIHNldCByZXF1ZXN0VmFsaWRhdG9ySWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3JlcXVlc3RWYWxpZGF0b3JJZCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gcmVzb3VyY2VfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfcmVzb3VyY2VJZDogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHJlc291cmNlSWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Jlc291cmNlSWQ7XG4gIH1cbiAgcHVibGljIHNldCByZXNvdXJjZUlkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZXNvdXJjZUlkID0gdmFsdWU7XG4gIH1cblxuICAvLyByZXN0X2FwaV9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9yZXN0QXBpSWQ6IHN0cmluZztcbiAgcHVibGljIGdldCByZXN0QXBpSWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Jlc3RBcGlJZDtcbiAgfVxuICBwdWJsaWMgc2V0IHJlc3RBcGlJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVzdEFwaUlkID0gdmFsdWU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHB1YmxpYyBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGFwaV9rZXlfcmVxdWlyZWQ6IHRoaXMuX2FwaUtleVJlcXVpcmVkLFxuICAgICAgYXV0aG9yaXphdGlvbjogdGhpcy5fYXV0aG9yaXphdGlvbixcbiAgICAgIGF1dGhvcml6YXRpb25fc2NvcGVzOiB0aGlzLl9hdXRob3JpemF0aW9uU2NvcGVzLFxuICAgICAgYXV0aG9yaXplcl9pZDogdGhpcy5fYXV0aG9yaXplcklkLFxuICAgICAgaHR0cF9tZXRob2Q6IHRoaXMuX2h0dHBNZXRob2QsXG4gICAgICByZXF1ZXN0X21vZGVsczogdGhpcy5fcmVxdWVzdE1vZGVscyxcbiAgICAgIHJlcXVlc3RfcGFyYW1ldGVyczogdGhpcy5fcmVxdWVzdFBhcmFtZXRlcnMsXG4gICAgICByZXF1ZXN0X3BhcmFtZXRlcnNfaW5fanNvbjogdGhpcy5fcmVxdWVzdFBhcmFtZXRlcnNJbkpzb24sXG4gICAgICByZXF1ZXN0X3ZhbGlkYXRvcl9pZDogdGhpcy5fcmVxdWVzdFZhbGlkYXRvcklkLFxuICAgICAgcmVzb3VyY2VfaWQ6IHRoaXMuX3Jlc291cmNlSWQsXG4gICAgICByZXN0X2FwaV9pZDogdGhpcy5fcmVzdEFwaUlkLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==