"use strict";
// https://www.terraform.io/docs/providers/aws/r/api_gateway_request_validator.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayRequestValidator = void 0;
const cdktf_1 = require("cdktf");
// Resource
class ApiGatewayRequestValidator extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_api_gateway_request_validator',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._name = config.name;
        this._restApiId = config.restApiId;
        this._validateRequestBody = config.validateRequestBody;
        this._validateRequestParameters = config.validateRequestParameters;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get restApiId() {
        return this._restApiId;
    }
    set restApiId(value) {
        this._restApiId = value;
    }
    get validateRequestBody() {
        return this._validateRequestBody;
    }
    set validateRequestBody(value) {
        this._validateRequestBody = value;
    }
    get validateRequestParameters() {
        return this._validateRequestParameters;
    }
    set validateRequestParameters(value) {
        this._validateRequestParameters = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            name: this._name,
            rest_api_id: this._restApiId,
            validate_request_body: this._validateRequestBody,
            validate_request_parameters: this._validateRequestParameters,
        };
    }
}
exports.ApiGatewayRequestValidator = ApiGatewayRequestValidator;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLWdhdGV3YXktcmVxdWVzdC12YWxpZGF0b3IuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvYXBpLWdhdGV3YXktcmVxdWVzdC12YWxpZGF0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG1GQUFtRjtBQUNuRiwyQ0FBMkM7OztBQWlDM0MsaUNBQTBDO0FBWTFDLFdBQVc7QUFFWCxNQUFhLDBCQUEyQixTQUFRLHlCQUFpQjtJQUUvRCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZCxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUF3QztRQUN2RixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLG1DQUFtQztZQUMxRCwwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLEtBQUs7YUFDcEI7WUFDRCxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDekIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztZQUNuQixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7U0FDNUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7SUFDckUsQ0FBQztJQVFELElBQVcsRUFBRTs7UUFDWCxhQUFPLElBQUksQ0FBQyxHQUFHLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBQ0QsSUFBVyxFQUFFLENBQUMsS0FBeUI7UUFDckMsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUNELElBQVcsbUJBQW1CLENBQUMsS0FBMEI7UUFDdkQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBSUQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcseUJBQXlCLENBQUMsS0FBMEI7UUFDN0QsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQztJQUMxQyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUwsb0JBQW9CO1FBQ3pCLE9BQU87WUFDTCxJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDaEIsV0FBVyxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzVCLHFCQUFxQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDaEQsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLDBCQUEwQjtTQUM3RCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBcEZELGdFQW9GQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9hd3Mvci9hcGlfZ2F0ZXdheV9yZXF1ZXN0X3ZhbGlkYXRvci5odG1sXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbi8qXG57XG4gIFwidmVyc2lvblwiOiAwLFxuICBcImJsb2NrXCI6IHtcbiAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgXCJpZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwibmFtZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInJlc3RfYXBpX2lkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwidmFsaWRhdGVfcmVxdWVzdF9ib2R5XCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwiYm9vbFwiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInZhbGlkYXRlX3JlcXVlc3RfcGFyYW1ldGVyc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9XG4gICAgfVxuICB9XG59XG4qL1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBUZXJyYWZvcm1SZXNvdXJjZSB9IGZyb20gJ2Nka3RmJztcbmltcG9ydCB7IFRlcnJhZm9ybU1ldGFBcmd1bWVudHMgfSBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBBcGlHYXRld2F5UmVxdWVzdFZhbGlkYXRvckNvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlc3RBcGlJZDogc3RyaW5nO1xuICByZWFkb25seSB2YWxpZGF0ZVJlcXVlc3RCb2R5PzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgdmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVycz86IGJvb2xlYW47XG59XG5cbi8vIFJlc291cmNlXG5cbmV4cG9ydCBjbGFzcyBBcGlHYXRld2F5UmVxdWVzdFZhbGlkYXRvciBleHRlbmRzIFRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IEFwaUdhdGV3YXlSZXF1ZXN0VmFsaWRhdG9yQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3NfYXBpX2dhdGV3YXlfcmVxdWVzdF92YWxpZGF0b3InLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAnYXdzJ1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlXG4gICAgfSk7XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX3Jlc3RBcGlJZCA9IGNvbmZpZy5yZXN0QXBpSWQ7XG4gICAgdGhpcy5fdmFsaWRhdGVSZXF1ZXN0Qm9keSA9IGNvbmZpZy52YWxpZGF0ZVJlcXVlc3RCb2R5O1xuICAgIHRoaXMuX3ZhbGlkYXRlUmVxdWVzdFBhcmFtZXRlcnMgPSBjb25maWcudmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVycztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZztcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQgPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIG5hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfbmFtZTogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9uYW1lID0gdmFsdWU7XG4gIH1cblxuICAvLyByZXN0X2FwaV9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9yZXN0QXBpSWQ6IHN0cmluZztcbiAgcHVibGljIGdldCByZXN0QXBpSWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Jlc3RBcGlJZDtcbiAgfVxuICBwdWJsaWMgc2V0IHJlc3RBcGlJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVzdEFwaUlkID0gdmFsdWU7XG4gIH1cblxuICAvLyB2YWxpZGF0ZV9yZXF1ZXN0X2JvZHkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdmFsaWRhdGVSZXF1ZXN0Qm9keT86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQgdmFsaWRhdGVSZXF1ZXN0Qm9keSgpIHtcbiAgICByZXR1cm4gdGhpcy5fdmFsaWRhdGVSZXF1ZXN0Qm9keTtcbiAgfVxuICBwdWJsaWMgc2V0IHZhbGlkYXRlUmVxdWVzdEJvZHkodmFsdWU6IGJvb2xlYW4gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl92YWxpZGF0ZVJlcXVlc3RCb2R5ID0gdmFsdWU7XG4gIH1cblxuICAvLyB2YWxpZGF0ZV9yZXF1ZXN0X3BhcmFtZXRlcnMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVycz86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQgdmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVycygpIHtcbiAgICByZXR1cm4gdGhpcy5fdmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVycztcbiAgfVxuICBwdWJsaWMgc2V0IHZhbGlkYXRlUmVxdWVzdFBhcmFtZXRlcnModmFsdWU6IGJvb2xlYW4gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl92YWxpZGF0ZVJlcXVlc3RQYXJhbWV0ZXJzID0gdmFsdWU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHB1YmxpYyBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWU6IHRoaXMuX25hbWUsXG4gICAgICByZXN0X2FwaV9pZDogdGhpcy5fcmVzdEFwaUlkLFxuICAgICAgdmFsaWRhdGVfcmVxdWVzdF9ib2R5OiB0aGlzLl92YWxpZGF0ZVJlcXVlc3RCb2R5LFxuICAgICAgdmFsaWRhdGVfcmVxdWVzdF9wYXJhbWV0ZXJzOiB0aGlzLl92YWxpZGF0ZVJlcXVlc3RQYXJhbWV0ZXJzLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==