import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayRestApiConfig extends TerraformMetaArguments {
    readonly apiKeySource?: string;
    readonly binaryMediaTypes?: string[];
    readonly body?: string;
    readonly description?: string;
    readonly minimumCompressionSize?: number;
    readonly name: string;
    readonly policy?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** endpoint_configuration block */
    readonly endpointConfiguration?: ApiGatewayRestApiEndpointConfiguration[];
}
export interface ApiGatewayRestApiEndpointConfiguration {
    readonly types: string[];
    readonly vpcEndpointIds?: string[];
}
export declare class ApiGatewayRestApi extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayRestApiConfig);
    private _apiKeySource?;
    get apiKeySource(): string | undefined;
    set apiKeySource(value: string | undefined);
    get arn(): string;
    private _binaryMediaTypes?;
    get binaryMediaTypes(): string[] | undefined;
    set binaryMediaTypes(value: string[] | undefined);
    private _body?;
    get body(): string | undefined;
    set body(value: string | undefined);
    get createdDate(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get executionArn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _minimumCompressionSize?;
    get minimumCompressionSize(): number | undefined;
    set minimumCompressionSize(value: number | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    get rootResourceId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _endpointConfiguration?;
    get endpointConfiguration(): ApiGatewayRestApiEndpointConfiguration[] | undefined;
    set endpointConfiguration(value: ApiGatewayRestApiEndpointConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
