import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayStageConfig extends TerraformMetaArguments {
    readonly cacheClusterEnabled?: boolean;
    readonly cacheClusterSize?: string;
    readonly clientCertificateId?: string;
    readonly deploymentId: string;
    readonly description?: string;
    readonly documentationVersion?: string;
    readonly restApiId: string;
    readonly stageName: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly variables?: {
        [key: string]: string;
    };
    readonly xrayTracingEnabled?: boolean;
    /** access_log_settings block */
    readonly accessLogSettings?: ApiGatewayStageAccessLogSettings[];
}
export interface ApiGatewayStageAccessLogSettings {
    readonly destinationArn: string;
    readonly format: string;
}
export declare class ApiGatewayStage extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayStageConfig);
    get arn(): string;
    private _cacheClusterEnabled?;
    get cacheClusterEnabled(): boolean | undefined;
    set cacheClusterEnabled(value: boolean | undefined);
    private _cacheClusterSize?;
    get cacheClusterSize(): string | undefined;
    set cacheClusterSize(value: string | undefined);
    private _clientCertificateId?;
    get clientCertificateId(): string | undefined;
    set clientCertificateId(value: string | undefined);
    private _deploymentId;
    get deploymentId(): string;
    set deploymentId(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _documentationVersion?;
    get documentationVersion(): string | undefined;
    set documentationVersion(value: string | undefined);
    get executionArn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get invokeUrl(): string;
    private _restApiId;
    get restApiId(): string;
    set restApiId(value: string);
    private _stageName;
    get stageName(): string;
    set stageName(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _variables?;
    get variables(): {
        [key: string]: string;
    } | undefined;
    set variables(value: {
        [key: string]: string;
    } | undefined);
    private _xrayTracingEnabled?;
    get xrayTracingEnabled(): boolean | undefined;
    set xrayTracingEnabled(value: boolean | undefined);
    private _accessLogSettings?;
    get accessLogSettings(): ApiGatewayStageAccessLogSettings[] | undefined;
    set accessLogSettings(value: ApiGatewayStageAccessLogSettings[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
