import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ApiGatewayUsagePlanConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly productCode?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** api_stages block */
    readonly apiStages?: ApiGatewayUsagePlanApiStages[];
    /** quota_settings block */
    readonly quotaSettings?: ApiGatewayUsagePlanQuotaSettings[];
    /** throttle_settings block */
    readonly throttleSettings?: ApiGatewayUsagePlanThrottleSettings[];
}
export interface ApiGatewayUsagePlanApiStages {
    readonly apiId: string;
    readonly stage: string;
}
export interface ApiGatewayUsagePlanQuotaSettings {
    readonly limit: number;
    readonly offset?: number;
    readonly period: string;
}
export interface ApiGatewayUsagePlanThrottleSettings {
    readonly burstLimit?: number;
    readonly rateLimit?: number;
}
export declare class ApiGatewayUsagePlan extends TerraformResource {
    constructor(scope: Construct, id: string, config: ApiGatewayUsagePlanConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _productCode?;
    get productCode(): string | undefined;
    set productCode(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _apiStages?;
    get apiStages(): ApiGatewayUsagePlanApiStages[] | undefined;
    set apiStages(value: ApiGatewayUsagePlanApiStages[] | undefined);
    private _quotaSettings?;
    get quotaSettings(): ApiGatewayUsagePlanQuotaSettings[] | undefined;
    set quotaSettings(value: ApiGatewayUsagePlanQuotaSettings[] | undefined);
    private _throttleSettings?;
    get throttleSettings(): ApiGatewayUsagePlanThrottleSettings[] | undefined;
    set throttleSettings(value: ApiGatewayUsagePlanThrottleSettings[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
