import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Apigatewayv2ApiConfig extends TerraformMetaArguments {
    readonly apiKeySelectionExpression?: string;
    readonly credentialsArn?: string;
    readonly description?: string;
    readonly name: string;
    readonly protocolType: string;
    readonly routeKey?: string;
    readonly routeSelectionExpression?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly target?: string;
    readonly version?: string;
    /** cors_configuration block */
    readonly corsConfiguration?: Apigatewayv2ApiCorsConfiguration[];
}
export interface Apigatewayv2ApiCorsConfiguration {
    readonly allowCredentials?: boolean;
    readonly allowHeaders?: string[];
    readonly allowMethods?: string[];
    readonly allowOrigins?: string[];
    readonly exposeHeaders?: string[];
    readonly maxAge?: number;
}
export declare class Apigatewayv2Api extends TerraformResource {
    constructor(scope: Construct, id: string, config: Apigatewayv2ApiConfig);
    get apiEndpoint(): string;
    private _apiKeySelectionExpression?;
    get apiKeySelectionExpression(): string | undefined;
    set apiKeySelectionExpression(value: string | undefined);
    get arn(): string;
    private _credentialsArn?;
    get credentialsArn(): string | undefined;
    set credentialsArn(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get executionArn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _protocolType;
    get protocolType(): string;
    set protocolType(value: string);
    private _routeKey?;
    get routeKey(): string | undefined;
    set routeKey(value: string | undefined);
    private _routeSelectionExpression?;
    get routeSelectionExpression(): string | undefined;
    set routeSelectionExpression(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _target?;
    get target(): string | undefined;
    set target(value: string | undefined);
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    private _corsConfiguration?;
    get corsConfiguration(): Apigatewayv2ApiCorsConfiguration[] | undefined;
    set corsConfiguration(value: Apigatewayv2ApiCorsConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
