import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Apigatewayv2AuthorizerConfig extends TerraformMetaArguments {
    readonly apiId: string;
    readonly authorizerCredentialsArn?: string;
    readonly authorizerType: string;
    readonly authorizerUri?: string;
    readonly identitySources: string[];
    readonly name: string;
    /** jwt_configuration block */
    readonly jwtConfiguration?: Apigatewayv2AuthorizerJwtConfiguration[];
}
export interface Apigatewayv2AuthorizerJwtConfiguration {
    readonly audience?: string[];
    readonly issuer?: string;
}
export declare class Apigatewayv2Authorizer extends TerraformResource {
    constructor(scope: Construct, id: string, config: Apigatewayv2AuthorizerConfig);
    private _apiId;
    get apiId(): string;
    set apiId(value: string);
    private _authorizerCredentialsArn?;
    get authorizerCredentialsArn(): string | undefined;
    set authorizerCredentialsArn(value: string | undefined);
    private _authorizerType;
    get authorizerType(): string;
    set authorizerType(value: string);
    private _authorizerUri?;
    get authorizerUri(): string | undefined;
    set authorizerUri(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identitySources;
    get identitySources(): string[];
    set identitySources(value: string[]);
    private _name;
    get name(): string;
    set name(value: string);
    private _jwtConfiguration?;
    get jwtConfiguration(): Apigatewayv2AuthorizerJwtConfiguration[] | undefined;
    set jwtConfiguration(value: Apigatewayv2AuthorizerJwtConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
