import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Apigatewayv2DomainNameConfig extends TerraformMetaArguments {
    readonly domainName: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** domain_name_configuration block */
    readonly domainNameConfiguration: Apigatewayv2DomainNameDomainNameConfiguration[];
    /** timeouts block */
    readonly timeouts?: Apigatewayv2DomainNameTimeouts;
}
export interface Apigatewayv2DomainNameDomainNameConfiguration {
    readonly certificateArn: string;
    readonly endpointType: string;
    readonly securityPolicy: string;
}
export interface Apigatewayv2DomainNameTimeouts {
    readonly update?: string;
}
export declare class Apigatewayv2DomainName extends TerraformResource {
    constructor(scope: Construct, id: string, config: Apigatewayv2DomainNameConfig);
    get apiMappingSelectionExpression(): string;
    get arn(): string;
    private _domainName;
    get domainName(): string;
    set domainName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _domainNameConfiguration;
    get domainNameConfiguration(): Apigatewayv2DomainNameDomainNameConfiguration[];
    set domainNameConfiguration(value: Apigatewayv2DomainNameDomainNameConfiguration[]);
    private _timeouts?;
    get timeouts(): Apigatewayv2DomainNameTimeouts | undefined;
    set timeouts(value: Apigatewayv2DomainNameTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
