import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Apigatewayv2IntegrationResponseConfig extends TerraformMetaArguments {
    readonly apiId: string;
    readonly contentHandlingStrategy?: string;
    readonly integrationId: string;
    readonly integrationResponseKey: string;
    readonly responseTemplates?: {
        [key: string]: string;
    };
    readonly templateSelectionExpression?: string;
}
export declare class Apigatewayv2IntegrationResponse extends TerraformResource {
    constructor(scope: Construct, id: string, config: Apigatewayv2IntegrationResponseConfig);
    private _apiId;
    get apiId(): string;
    set apiId(value: string);
    private _contentHandlingStrategy?;
    get contentHandlingStrategy(): string | undefined;
    set contentHandlingStrategy(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _integrationId;
    get integrationId(): string;
    set integrationId(value: string);
    private _integrationResponseKey;
    get integrationResponseKey(): string;
    set integrationResponseKey(value: string);
    private _responseTemplates?;
    get responseTemplates(): {
        [key: string]: string;
    } | undefined;
    set responseTemplates(value: {
        [key: string]: string;
    } | undefined);
    private _templateSelectionExpression?;
    get templateSelectionExpression(): string | undefined;
    set templateSelectionExpression(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
