import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Apigatewayv2IntegrationConfig extends TerraformMetaArguments {
    readonly apiId: string;
    readonly connectionId?: string;
    readonly connectionType?: string;
    readonly contentHandlingStrategy?: string;
    readonly credentialsArn?: string;
    readonly description?: string;
    readonly integrationMethod?: string;
    readonly integrationType: string;
    readonly integrationUri?: string;
    readonly passthroughBehavior?: string;
    readonly payloadFormatVersion?: string;
    readonly requestTemplates?: {
        [key: string]: string;
    };
    readonly templateSelectionExpression?: string;
    readonly timeoutMilliseconds?: number;
}
export declare class Apigatewayv2Integration extends TerraformResource {
    constructor(scope: Construct, id: string, config: Apigatewayv2IntegrationConfig);
    private _apiId;
    get apiId(): string;
    set apiId(value: string);
    private _connectionId?;
    get connectionId(): string | undefined;
    set connectionId(value: string | undefined);
    private _connectionType?;
    get connectionType(): string | undefined;
    set connectionType(value: string | undefined);
    private _contentHandlingStrategy?;
    get contentHandlingStrategy(): string | undefined;
    set contentHandlingStrategy(value: string | undefined);
    private _credentialsArn?;
    get credentialsArn(): string | undefined;
    set credentialsArn(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _integrationMethod?;
    get integrationMethod(): string | undefined;
    set integrationMethod(value: string | undefined);
    get integrationResponseSelectionExpression(): string;
    private _integrationType;
    get integrationType(): string;
    set integrationType(value: string);
    private _integrationUri?;
    get integrationUri(): string | undefined;
    set integrationUri(value: string | undefined);
    private _passthroughBehavior?;
    get passthroughBehavior(): string | undefined;
    set passthroughBehavior(value: string | undefined);
    private _payloadFormatVersion?;
    get payloadFormatVersion(): string | undefined;
    set payloadFormatVersion(value: string | undefined);
    private _requestTemplates?;
    get requestTemplates(): {
        [key: string]: string;
    } | undefined;
    set requestTemplates(value: {
        [key: string]: string;
    } | undefined);
    private _templateSelectionExpression?;
    get templateSelectionExpression(): string | undefined;
    set templateSelectionExpression(value: string | undefined);
    private _timeoutMilliseconds?;
    get timeoutMilliseconds(): number | undefined;
    set timeoutMilliseconds(value: number | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
