"use strict";
// https://www.terraform.io/docs/providers/aws/r/apigatewayv2_integration.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Apigatewayv2Integration = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Apigatewayv2Integration extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_apigatewayv2_integration',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._apiId = config.apiId;
        this._connectionId = config.connectionId;
        this._connectionType = config.connectionType;
        this._contentHandlingStrategy = config.contentHandlingStrategy;
        this._credentialsArn = config.credentialsArn;
        this._description = config.description;
        this._integrationMethod = config.integrationMethod;
        this._integrationType = config.integrationType;
        this._integrationUri = config.integrationUri;
        this._passthroughBehavior = config.passthroughBehavior;
        this._payloadFormatVersion = config.payloadFormatVersion;
        this._requestTemplates = config.requestTemplates;
        this._templateSelectionExpression = config.templateSelectionExpression;
        this._timeoutMilliseconds = config.timeoutMilliseconds;
    }
    get apiId() {
        return this._apiId;
    }
    set apiId(value) {
        this._apiId = value;
    }
    get connectionId() {
        return this._connectionId;
    }
    set connectionId(value) {
        this._connectionId = value;
    }
    get connectionType() {
        return this._connectionType;
    }
    set connectionType(value) {
        this._connectionType = value;
    }
    get contentHandlingStrategy() {
        return this._contentHandlingStrategy;
    }
    set contentHandlingStrategy(value) {
        this._contentHandlingStrategy = value;
    }
    get credentialsArn() {
        return this._credentialsArn;
    }
    set credentialsArn(value) {
        this._credentialsArn = value;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get integrationMethod() {
        return this._integrationMethod;
    }
    set integrationMethod(value) {
        this._integrationMethod = value;
    }
    // integration_response_selection_expression - computed: true, optional: false, required: true
    get integrationResponseSelectionExpression() {
        return this.getStringAttribute('integration_response_selection_expression');
    }
    get integrationType() {
        return this._integrationType;
    }
    set integrationType(value) {
        this._integrationType = value;
    }
    get integrationUri() {
        return this._integrationUri;
    }
    set integrationUri(value) {
        this._integrationUri = value;
    }
    get passthroughBehavior() {
        return this._passthroughBehavior;
    }
    set passthroughBehavior(value) {
        this._passthroughBehavior = value;
    }
    get payloadFormatVersion() {
        return this._payloadFormatVersion;
    }
    set payloadFormatVersion(value) {
        this._payloadFormatVersion = value;
    }
    get requestTemplates() {
        return this._requestTemplates;
    }
    set requestTemplates(value) {
        this._requestTemplates = value;
    }
    get templateSelectionExpression() {
        return this._templateSelectionExpression;
    }
    set templateSelectionExpression(value) {
        this._templateSelectionExpression = value;
    }
    get timeoutMilliseconds() {
        return this._timeoutMilliseconds;
    }
    set timeoutMilliseconds(value) {
        this._timeoutMilliseconds = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            api_id: this._apiId,
            connection_id: this._connectionId,
            connection_type: this._connectionType,
            content_handling_strategy: this._contentHandlingStrategy,
            credentials_arn: this._credentialsArn,
            description: this._description,
            integration_method: this._integrationMethod,
            integration_type: this._integrationType,
            integration_uri: this._integrationUri,
            passthrough_behavior: this._passthroughBehavior,
            payload_format_version: this._payloadFormatVersion,
            request_templates: this._requestTemplates,
            template_selection_expression: this._templateSelectionExpression,
            timeout_milliseconds: this._timeoutMilliseconds,
        };
    }
}
exports.Apigatewayv2Integration = Apigatewayv2Integration;
//# sourceMappingURL=data:application/json;base64,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