import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Apigatewayv2RouteConfig extends TerraformMetaArguments {
    readonly apiId: string;
    readonly apiKeyRequired?: boolean;
    readonly authorizationScopes?: string[];
    readonly authorizationType?: string;
    readonly authorizerId?: string;
    readonly modelSelectionExpression?: string;
    readonly operationName?: string;
    readonly requestModels?: {
        [key: string]: string;
    };
    readonly routeKey: string;
    readonly routeResponseSelectionExpression?: string;
    readonly target?: string;
}
export declare class Apigatewayv2Route extends TerraformResource {
    constructor(scope: Construct, id: string, config: Apigatewayv2RouteConfig);
    private _apiId;
    get apiId(): string;
    set apiId(value: string);
    private _apiKeyRequired?;
    get apiKeyRequired(): boolean | undefined;
    set apiKeyRequired(value: boolean | undefined);
    private _authorizationScopes?;
    get authorizationScopes(): string[] | undefined;
    set authorizationScopes(value: string[] | undefined);
    private _authorizationType?;
    get authorizationType(): string | undefined;
    set authorizationType(value: string | undefined);
    private _authorizerId?;
    get authorizerId(): string | undefined;
    set authorizerId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _modelSelectionExpression?;
    get modelSelectionExpression(): string | undefined;
    set modelSelectionExpression(value: string | undefined);
    private _operationName?;
    get operationName(): string | undefined;
    set operationName(value: string | undefined);
    private _requestModels?;
    get requestModels(): {
        [key: string]: string;
    } | undefined;
    set requestModels(value: {
        [key: string]: string;
    } | undefined);
    private _routeKey;
    get routeKey(): string;
    set routeKey(value: string);
    private _routeResponseSelectionExpression?;
    get routeResponseSelectionExpression(): string | undefined;
    set routeResponseSelectionExpression(value: string | undefined);
    private _target?;
    get target(): string | undefined;
    set target(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
