import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Apigatewayv2StageConfig extends TerraformMetaArguments {
    readonly apiId: string;
    readonly autoDeploy?: boolean;
    readonly clientCertificateId?: string;
    readonly deploymentId?: string;
    readonly description?: string;
    readonly name: string;
    readonly stageVariables?: {
        [key: string]: string;
    };
    readonly tags?: {
        [key: string]: string;
    };
    /** access_log_settings block */
    readonly accessLogSettings?: Apigatewayv2StageAccessLogSettings[];
    /** default_route_settings block */
    readonly defaultRouteSettings?: Apigatewayv2StageDefaultRouteSettings[];
    /** route_settings block */
    readonly routeSettings?: Apigatewayv2StageRouteSettings[];
}
export interface Apigatewayv2StageAccessLogSettings {
    readonly destinationArn: string;
    readonly format: string;
}
export interface Apigatewayv2StageDefaultRouteSettings {
    readonly dataTraceEnabled?: boolean;
    readonly detailedMetricsEnabled?: boolean;
    readonly loggingLevel?: string;
    readonly throttlingBurstLimit?: number;
    readonly throttlingRateLimit?: number;
}
export interface Apigatewayv2StageRouteSettings {
    readonly dataTraceEnabled?: boolean;
    readonly detailedMetricsEnabled?: boolean;
    readonly loggingLevel?: string;
    readonly routeKey: string;
    readonly throttlingBurstLimit?: number;
    readonly throttlingRateLimit?: number;
}
export declare class Apigatewayv2Stage extends TerraformResource {
    constructor(scope: Construct, id: string, config: Apigatewayv2StageConfig);
    private _apiId;
    get apiId(): string;
    set apiId(value: string);
    get arn(): string;
    private _autoDeploy?;
    get autoDeploy(): boolean | undefined;
    set autoDeploy(value: boolean | undefined);
    private _clientCertificateId?;
    get clientCertificateId(): string | undefined;
    set clientCertificateId(value: string | undefined);
    private _deploymentId?;
    get deploymentId(): string | undefined;
    set deploymentId(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get executionArn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get invokeUrl(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _stageVariables?;
    get stageVariables(): {
        [key: string]: string;
    } | undefined;
    set stageVariables(value: {
        [key: string]: string;
    } | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _accessLogSettings?;
    get accessLogSettings(): Apigatewayv2StageAccessLogSettings[] | undefined;
    set accessLogSettings(value: Apigatewayv2StageAccessLogSettings[] | undefined);
    private _defaultRouteSettings?;
    get defaultRouteSettings(): Apigatewayv2StageDefaultRouteSettings[] | undefined;
    set defaultRouteSettings(value: Apigatewayv2StageDefaultRouteSettings[] | undefined);
    private _routeSettings?;
    get routeSettings(): Apigatewayv2StageRouteSettings[] | undefined;
    set routeSettings(value: Apigatewayv2StageRouteSettings[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
