import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppautoscalingPolicyConfig extends TerraformMetaArguments {
    readonly adjustmentType?: string;
    readonly cooldown?: number;
    readonly metricAggregationType?: string;
    readonly minAdjustmentMagnitude?: number;
    readonly name: string;
    readonly policyType?: string;
    readonly resourceId: string;
    readonly scalableDimension: string;
    readonly serviceNamespace: string;
    /** step_adjustment block */
    readonly stepAdjustment?: AppautoscalingPolicyStepAdjustment[];
    /** step_scaling_policy_configuration block */
    readonly stepScalingPolicyConfiguration?: AppautoscalingPolicyStepScalingPolicyConfiguration[];
    /** target_tracking_scaling_policy_configuration block */
    readonly targetTrackingScalingPolicyConfiguration?: AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration[];
}
export interface AppautoscalingPolicyStepAdjustment {
    readonly metricIntervalLowerBound?: string;
    readonly metricIntervalUpperBound?: string;
    readonly scalingAdjustment: number;
}
export interface AppautoscalingPolicyStepScalingPolicyConfigurationStepAdjustment {
    readonly metricIntervalLowerBound?: string;
    readonly metricIntervalUpperBound?: string;
    readonly scalingAdjustment: number;
}
export interface AppautoscalingPolicyStepScalingPolicyConfiguration {
    readonly adjustmentType?: string;
    readonly cooldown?: number;
    readonly metricAggregationType?: string;
    readonly minAdjustmentMagnitude?: number;
    /** step_adjustment block */
    readonly stepAdjustment?: AppautoscalingPolicyStepScalingPolicyConfigurationStepAdjustment[];
}
export interface AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensions {
    readonly name: string;
    readonly value: string;
}
export interface AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification {
    readonly metricName: string;
    readonly namespace: string;
    readonly statistic: string;
    readonly unit?: string;
    /** dimensions block */
    readonly dimensions?: AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensions[];
}
export interface AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification {
    readonly predefinedMetricType: string;
    readonly resourceLabel?: string;
}
export interface AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration {
    readonly disableScaleIn?: boolean;
    readonly scaleInCooldown?: number;
    readonly scaleOutCooldown?: number;
    readonly targetValue: number;
    /** customized_metric_specification block */
    readonly customizedMetricSpecification?: AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification[];
    /** predefined_metric_specification block */
    readonly predefinedMetricSpecification?: AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification[];
}
export declare class AppautoscalingPolicy extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppautoscalingPolicyConfig);
    private _adjustmentType?;
    get adjustmentType(): string | undefined;
    set adjustmentType(value: string | undefined);
    get arn(): string;
    private _cooldown?;
    get cooldown(): number | undefined;
    set cooldown(value: number | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricAggregationType?;
    get metricAggregationType(): string | undefined;
    set metricAggregationType(value: string | undefined);
    private _minAdjustmentMagnitude?;
    get minAdjustmentMagnitude(): number | undefined;
    set minAdjustmentMagnitude(value: number | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _policyType?;
    get policyType(): string | undefined;
    set policyType(value: string | undefined);
    private _resourceId;
    get resourceId(): string;
    set resourceId(value: string);
    private _scalableDimension;
    get scalableDimension(): string;
    set scalableDimension(value: string);
    private _serviceNamespace;
    get serviceNamespace(): string;
    set serviceNamespace(value: string);
    private _stepAdjustment?;
    get stepAdjustment(): AppautoscalingPolicyStepAdjustment[] | undefined;
    set stepAdjustment(value: AppautoscalingPolicyStepAdjustment[] | undefined);
    private _stepScalingPolicyConfiguration?;
    get stepScalingPolicyConfiguration(): AppautoscalingPolicyStepScalingPolicyConfiguration[] | undefined;
    set stepScalingPolicyConfiguration(value: AppautoscalingPolicyStepScalingPolicyConfiguration[] | undefined);
    private _targetTrackingScalingPolicyConfiguration?;
    get targetTrackingScalingPolicyConfiguration(): AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration[] | undefined;
    set targetTrackingScalingPolicyConfiguration(value: AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
