import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppautoscalingScheduledActionConfig extends TerraformMetaArguments {
    readonly endTime?: string;
    readonly name: string;
    readonly resourceId: string;
    readonly scalableDimension?: string;
    readonly schedule?: string;
    readonly serviceNamespace: string;
    readonly startTime?: string;
    /** scalable_target_action block */
    readonly scalableTargetAction?: AppautoscalingScheduledActionScalableTargetAction[];
}
export interface AppautoscalingScheduledActionScalableTargetAction {
    readonly maxCapacity?: number;
    readonly minCapacity?: number;
}
export declare class AppautoscalingScheduledAction extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppautoscalingScheduledActionConfig);
    get arn(): string;
    private _endTime?;
    get endTime(): string | undefined;
    set endTime(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _resourceId;
    get resourceId(): string;
    set resourceId(value: string);
    private _scalableDimension?;
    get scalableDimension(): string | undefined;
    set scalableDimension(value: string | undefined);
    private _schedule?;
    get schedule(): string | undefined;
    set schedule(value: string | undefined);
    private _serviceNamespace;
    get serviceNamespace(): string;
    set serviceNamespace(value: string);
    private _startTime?;
    get startTime(): string | undefined;
    set startTime(value: string | undefined);
    private _scalableTargetAction?;
    get scalableTargetAction(): AppautoscalingScheduledActionScalableTargetAction[] | undefined;
    set scalableTargetAction(value: AppautoscalingScheduledActionScalableTargetAction[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
