"use strict";
// https://www.terraform.io/docs/providers/aws/r/appautoscaling_scheduled_action.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppautoscalingScheduledAction = void 0;
const cdktf_1 = require("cdktf");
// Resource
class AppautoscalingScheduledAction extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_appautoscaling_scheduled_action',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._endTime = config.endTime;
        this._name = config.name;
        this._resourceId = config.resourceId;
        this._scalableDimension = config.scalableDimension;
        this._schedule = config.schedule;
        this._serviceNamespace = config.serviceNamespace;
        this._startTime = config.startTime;
        this._scalableTargetAction = config.scalableTargetAction;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get endTime() {
        return this._endTime;
    }
    set endTime(value) {
        this._endTime = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get resourceId() {
        return this._resourceId;
    }
    set resourceId(value) {
        this._resourceId = value;
    }
    get scalableDimension() {
        return this._scalableDimension;
    }
    set scalableDimension(value) {
        this._scalableDimension = value;
    }
    get schedule() {
        return this._schedule;
    }
    set schedule(value) {
        this._schedule = value;
    }
    get serviceNamespace() {
        return this._serviceNamespace;
    }
    set serviceNamespace(value) {
        this._serviceNamespace = value;
    }
    get startTime() {
        return this._startTime;
    }
    set startTime(value) {
        this._startTime = value;
    }
    get scalableTargetAction() {
        return this._scalableTargetAction;
    }
    set scalableTargetAction(value) {
        this._scalableTargetAction = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            end_time: this._endTime,
            name: this._name,
            resource_id: this._resourceId,
            scalable_dimension: this._scalableDimension,
            schedule: this._schedule,
            service_namespace: this._serviceNamespace,
            start_time: this._startTime,
            scalable_target_action: this._scalableTargetAction,
        };
    }
}
exports.AppautoscalingScheduledAction = AppautoscalingScheduledAction;
//# sourceMappingURL=data:application/json;base64,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