import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppmeshMeshConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** spec block */
    readonly spec?: AppmeshMeshSpec[];
}
export interface AppmeshMeshSpecEgressFilter {
    readonly type?: string;
}
export interface AppmeshMeshSpec {
    /** egress_filter block */
    readonly egressFilter?: AppmeshMeshSpecEgressFilter[];
}
export declare class AppmeshMesh extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppmeshMeshConfig);
    get arn(): string;
    get createdDate(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastUpdatedDate(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _spec?;
    get spec(): AppmeshMeshSpec[] | undefined;
    set spec(value: AppmeshMeshSpec[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
