import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppmeshRouteConfig extends TerraformMetaArguments {
    readonly meshName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly virtualRouterName: string;
    /** spec block */
    readonly spec: AppmeshRouteSpec[];
}
export interface AppmeshRouteSpecHttpRouteActionWeightedTarget {
    readonly virtualNode: string;
    readonly weight: number;
}
export interface AppmeshRouteSpecHttpRouteAction {
    /** weighted_target block */
    readonly weightedTarget: AppmeshRouteSpecHttpRouteActionWeightedTarget[];
}
export interface AppmeshRouteSpecHttpRouteMatchHeaderMatchRange {
    readonly end: number;
    readonly start: number;
}
export interface AppmeshRouteSpecHttpRouteMatchHeaderMatch {
    readonly exact?: string;
    readonly prefix?: string;
    readonly regex?: string;
    readonly suffix?: string;
    /** range block */
    readonly range?: AppmeshRouteSpecHttpRouteMatchHeaderMatchRange[];
}
export interface AppmeshRouteSpecHttpRouteMatchHeader {
    readonly invert?: boolean;
    readonly name: string;
    /** match block */
    readonly match?: AppmeshRouteSpecHttpRouteMatchHeaderMatch[];
}
export interface AppmeshRouteSpecHttpRouteMatch {
    readonly method?: string;
    readonly prefix: string;
    readonly scheme?: string;
    /** header block */
    readonly header?: AppmeshRouteSpecHttpRouteMatchHeader[];
}
export interface AppmeshRouteSpecHttpRoute {
    /** action block */
    readonly action: AppmeshRouteSpecHttpRouteAction[];
    /** match block */
    readonly match: AppmeshRouteSpecHttpRouteMatch[];
}
export interface AppmeshRouteSpecTcpRouteActionWeightedTarget {
    readonly virtualNode: string;
    readonly weight: number;
}
export interface AppmeshRouteSpecTcpRouteAction {
    /** weighted_target block */
    readonly weightedTarget: AppmeshRouteSpecTcpRouteActionWeightedTarget[];
}
export interface AppmeshRouteSpecTcpRoute {
    /** action block */
    readonly action: AppmeshRouteSpecTcpRouteAction[];
}
export interface AppmeshRouteSpec {
    readonly priority?: number;
    /** http_route block */
    readonly httpRoute?: AppmeshRouteSpecHttpRoute[];
    /** tcp_route block */
    readonly tcpRoute?: AppmeshRouteSpecTcpRoute[];
}
export declare class AppmeshRoute extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppmeshRouteConfig);
    get arn(): string;
    get createdDate(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastUpdatedDate(): string;
    private _meshName;
    get meshName(): string;
    set meshName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _virtualRouterName;
    get virtualRouterName(): string;
    set virtualRouterName(value: string);
    private _spec;
    get spec(): AppmeshRouteSpec[];
    set spec(value: AppmeshRouteSpec[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
