import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppmeshVirtualNodeConfig extends TerraformMetaArguments {
    readonly meshName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** spec block */
    readonly spec: AppmeshVirtualNodeSpec[];
}
export interface AppmeshVirtualNodeSpecBackendVirtualService {
    readonly virtualServiceName: string;
}
export interface AppmeshVirtualNodeSpecBackend {
    /** virtual_service block */
    readonly virtualService?: AppmeshVirtualNodeSpecBackendVirtualService[];
}
export interface AppmeshVirtualNodeSpecListenerHealthCheck {
    readonly healthyThreshold: number;
    readonly intervalMillis: number;
    readonly path?: string;
    readonly port?: number;
    readonly protocol: string;
    readonly timeoutMillis: number;
    readonly unhealthyThreshold: number;
}
export interface AppmeshVirtualNodeSpecListenerPortMapping {
    readonly port: number;
    readonly protocol: string;
}
export interface AppmeshVirtualNodeSpecListener {
    /** health_check block */
    readonly healthCheck?: AppmeshVirtualNodeSpecListenerHealthCheck[];
    /** port_mapping block */
    readonly portMapping: AppmeshVirtualNodeSpecListenerPortMapping[];
}
export interface AppmeshVirtualNodeSpecLoggingAccessLogFile {
    readonly path: string;
}
export interface AppmeshVirtualNodeSpecLoggingAccessLog {
    /** file block */
    readonly file?: AppmeshVirtualNodeSpecLoggingAccessLogFile[];
}
export interface AppmeshVirtualNodeSpecLogging {
    /** access_log block */
    readonly accessLog?: AppmeshVirtualNodeSpecLoggingAccessLog[];
}
export interface AppmeshVirtualNodeSpecServiceDiscoveryAwsCloudMap {
    readonly attributes?: {
        [key: string]: string;
    };
    readonly namespaceName: string;
    readonly serviceName: string;
}
export interface AppmeshVirtualNodeSpecServiceDiscoveryDns {
    readonly hostname: string;
    readonly serviceName?: string;
}
export interface AppmeshVirtualNodeSpecServiceDiscovery {
    /** aws_cloud_map block */
    readonly awsCloudMap?: AppmeshVirtualNodeSpecServiceDiscoveryAwsCloudMap[];
    /** dns block */
    readonly dns?: AppmeshVirtualNodeSpecServiceDiscoveryDns[];
}
export interface AppmeshVirtualNodeSpec {
    readonly backends?: string[];
    /** backend block */
    readonly backend?: AppmeshVirtualNodeSpecBackend[];
    /** listener block */
    readonly listener?: AppmeshVirtualNodeSpecListener[];
    /** logging block */
    readonly logging?: AppmeshVirtualNodeSpecLogging[];
    /** service_discovery block */
    readonly serviceDiscovery?: AppmeshVirtualNodeSpecServiceDiscovery[];
}
export declare class AppmeshVirtualNode extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppmeshVirtualNodeConfig);
    get arn(): string;
    get createdDate(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastUpdatedDate(): string;
    private _meshName;
    get meshName(): string;
    set meshName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _spec;
    get spec(): AppmeshVirtualNodeSpec[];
    set spec(value: AppmeshVirtualNodeSpec[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
