import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppmeshVirtualRouterConfig extends TerraformMetaArguments {
    readonly meshName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** spec block */
    readonly spec: AppmeshVirtualRouterSpec[];
}
export interface AppmeshVirtualRouterSpecListenerPortMapping {
    readonly port: number;
    readonly protocol: string;
}
export interface AppmeshVirtualRouterSpecListener {
    /** port_mapping block */
    readonly portMapping: AppmeshVirtualRouterSpecListenerPortMapping[];
}
export interface AppmeshVirtualRouterSpec {
    readonly serviceNames?: string[];
    /** listener block */
    readonly listener: AppmeshVirtualRouterSpecListener[];
}
export declare class AppmeshVirtualRouter extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppmeshVirtualRouterConfig);
    get arn(): string;
    get createdDate(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastUpdatedDate(): string;
    private _meshName;
    get meshName(): string;
    set meshName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _spec;
    get spec(): AppmeshVirtualRouterSpec[];
    set spec(value: AppmeshVirtualRouterSpec[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
