import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppmeshVirtualServiceConfig extends TerraformMetaArguments {
    readonly meshName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** spec block */
    readonly spec: AppmeshVirtualServiceSpec[];
}
export interface AppmeshVirtualServiceSpecProviderVirtualNode {
    readonly virtualNodeName: string;
}
export interface AppmeshVirtualServiceSpecProviderVirtualRouter {
    readonly virtualRouterName: string;
}
export interface AppmeshVirtualServiceSpecProvider {
    /** virtual_node block */
    readonly virtualNode?: AppmeshVirtualServiceSpecProviderVirtualNode[];
    /** virtual_router block */
    readonly virtualRouter?: AppmeshVirtualServiceSpecProviderVirtualRouter[];
}
export interface AppmeshVirtualServiceSpec {
    /** provider block */
    readonly provider?: AppmeshVirtualServiceSpecProvider[];
}
export declare class AppmeshVirtualService extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppmeshVirtualServiceConfig);
    get arn(): string;
    get createdDate(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastUpdatedDate(): string;
    private _meshName;
    get meshName(): string;
    set meshName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _spec;
    get spec(): AppmeshVirtualServiceSpec[];
    set spec(value: AppmeshVirtualServiceSpec[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
