import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppsyncDatasourceConfig extends TerraformMetaArguments {
    readonly apiId: string;
    readonly description?: string;
    readonly name: string;
    readonly serviceRoleArn?: string;
    readonly type: string;
    /** dynamodb_config block */
    readonly dynamodbConfig?: AppsyncDatasourceDynamodbConfig[];
    /** elasticsearch_config block */
    readonly elasticsearchConfig?: AppsyncDatasourceElasticsearchConfig[];
    /** http_config block */
    readonly httpConfig?: AppsyncDatasourceHttpConfig[];
    /** lambda_config block */
    readonly lambdaConfig?: AppsyncDatasourceLambdaConfig[];
}
export interface AppsyncDatasourceDynamodbConfig {
    readonly region?: string;
    readonly tableName: string;
    readonly useCallerCredentials?: boolean;
}
export interface AppsyncDatasourceElasticsearchConfig {
    readonly endpoint: string;
    readonly region?: string;
}
export interface AppsyncDatasourceHttpConfig {
    readonly endpoint: string;
}
export interface AppsyncDatasourceLambdaConfig {
    readonly functionArn: string;
}
export declare class AppsyncDatasource extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppsyncDatasourceConfig);
    private _apiId;
    get apiId(): string;
    set apiId(value: string);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _serviceRoleArn?;
    get serviceRoleArn(): string | undefined;
    set serviceRoleArn(value: string | undefined);
    private _type;
    get type(): string;
    set type(value: string);
    private _dynamodbConfig?;
    get dynamodbConfig(): AppsyncDatasourceDynamodbConfig[] | undefined;
    set dynamodbConfig(value: AppsyncDatasourceDynamodbConfig[] | undefined);
    private _elasticsearchConfig?;
    get elasticsearchConfig(): AppsyncDatasourceElasticsearchConfig[] | undefined;
    set elasticsearchConfig(value: AppsyncDatasourceElasticsearchConfig[] | undefined);
    private _httpConfig?;
    get httpConfig(): AppsyncDatasourceHttpConfig[] | undefined;
    set httpConfig(value: AppsyncDatasourceHttpConfig[] | undefined);
    private _lambdaConfig?;
    get lambdaConfig(): AppsyncDatasourceLambdaConfig[] | undefined;
    set lambdaConfig(value: AppsyncDatasourceLambdaConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
