import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppsyncFunctionConfig extends TerraformMetaArguments {
    readonly apiId: string;
    readonly dataSource: string;
    readonly description?: string;
    readonly functionVersion?: string;
    readonly name: string;
    readonly requestMappingTemplate: string;
    readonly responseMappingTemplate: string;
}
export declare class AppsyncFunction extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppsyncFunctionConfig);
    private _apiId;
    get apiId(): string;
    set apiId(value: string);
    get arn(): string;
    private _dataSource;
    get dataSource(): string;
    set dataSource(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get functionId(): string;
    private _functionVersion?;
    get functionVersion(): string | undefined;
    set functionVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _requestMappingTemplate;
    get requestMappingTemplate(): string;
    set requestMappingTemplate(value: string);
    private _responseMappingTemplate;
    get responseMappingTemplate(): string;
    set responseMappingTemplate(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
