import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppsyncGraphqlApiConfig extends TerraformMetaArguments {
    readonly authenticationType: string;
    readonly name: string;
    readonly schema?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly xrayEnabled?: boolean;
    /** additional_authentication_provider block */
    readonly additionalAuthenticationProvider?: AppsyncGraphqlApiAdditionalAuthenticationProvider[];
    /** log_config block */
    readonly logConfig?: AppsyncGraphqlApiLogConfig[];
    /** openid_connect_config block */
    readonly openidConnectConfig?: AppsyncGraphqlApiOpenidConnectConfig[];
    /** user_pool_config block */
    readonly userPoolConfig?: AppsyncGraphqlApiUserPoolConfig[];
}
export interface AppsyncGraphqlApiAdditionalAuthenticationProviderOpenidConnectConfig {
    readonly authTtl?: number;
    readonly clientId?: string;
    readonly iatTtl?: number;
    readonly issuer: string;
}
export interface AppsyncGraphqlApiAdditionalAuthenticationProviderUserPoolConfig {
    readonly appIdClientRegex?: string;
    readonly awsRegion?: string;
    readonly userPoolId: string;
}
export interface AppsyncGraphqlApiAdditionalAuthenticationProvider {
    readonly authenticationType: string;
    /** openid_connect_config block */
    readonly openidConnectConfig?: AppsyncGraphqlApiAdditionalAuthenticationProviderOpenidConnectConfig[];
    /** user_pool_config block */
    readonly userPoolConfig?: AppsyncGraphqlApiAdditionalAuthenticationProviderUserPoolConfig[];
}
export interface AppsyncGraphqlApiLogConfig {
    readonly cloudwatchLogsRoleArn: string;
    readonly excludeVerboseContent?: boolean;
    readonly fieldLogLevel: string;
}
export interface AppsyncGraphqlApiOpenidConnectConfig {
    readonly authTtl?: number;
    readonly clientId?: string;
    readonly iatTtl?: number;
    readonly issuer: string;
}
export interface AppsyncGraphqlApiUserPoolConfig {
    readonly appIdClientRegex?: string;
    readonly awsRegion?: string;
    readonly defaultAction: string;
    readonly userPoolId: string;
}
export declare class AppsyncGraphqlApi extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppsyncGraphqlApiConfig);
    get arn(): string;
    private _authenticationType;
    get authenticationType(): string;
    set authenticationType(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _schema?;
    get schema(): string | undefined;
    set schema(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    uris(key: string): string;
    private _xrayEnabled?;
    get xrayEnabled(): boolean | undefined;
    set xrayEnabled(value: boolean | undefined);
    private _additionalAuthenticationProvider?;
    get additionalAuthenticationProvider(): AppsyncGraphqlApiAdditionalAuthenticationProvider[] | undefined;
    set additionalAuthenticationProvider(value: AppsyncGraphqlApiAdditionalAuthenticationProvider[] | undefined);
    private _logConfig?;
    get logConfig(): AppsyncGraphqlApiLogConfig[] | undefined;
    set logConfig(value: AppsyncGraphqlApiLogConfig[] | undefined);
    private _openidConnectConfig?;
    get openidConnectConfig(): AppsyncGraphqlApiOpenidConnectConfig[] | undefined;
    set openidConnectConfig(value: AppsyncGraphqlApiOpenidConnectConfig[] | undefined);
    private _userPoolConfig?;
    get userPoolConfig(): AppsyncGraphqlApiUserPoolConfig[] | undefined;
    set userPoolConfig(value: AppsyncGraphqlApiUserPoolConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
