import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AppsyncResolverConfig extends TerraformMetaArguments {
    readonly apiId: string;
    readonly dataSource?: string;
    readonly field: string;
    readonly kind?: string;
    readonly requestTemplate: string;
    readonly responseTemplate: string;
    readonly type: string;
    /** caching_config block */
    readonly cachingConfig?: AppsyncResolverCachingConfig[];
    /** pipeline_config block */
    readonly pipelineConfig?: AppsyncResolverPipelineConfig[];
}
export interface AppsyncResolverCachingConfig {
    readonly cachingKeys?: string[];
    readonly ttl?: number;
}
export interface AppsyncResolverPipelineConfig {
    readonly functions?: string[];
}
export declare class AppsyncResolver extends TerraformResource {
    constructor(scope: Construct, id: string, config: AppsyncResolverConfig);
    private _apiId;
    get apiId(): string;
    set apiId(value: string);
    get arn(): string;
    private _dataSource?;
    get dataSource(): string | undefined;
    set dataSource(value: string | undefined);
    private _field;
    get field(): string;
    set field(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kind?;
    get kind(): string | undefined;
    set kind(value: string | undefined);
    private _requestTemplate;
    get requestTemplate(): string;
    set requestTemplate(value: string);
    private _responseTemplate;
    get responseTemplate(): string;
    set responseTemplate(value: string);
    private _type;
    get type(): string;
    set type(value: string);
    private _cachingConfig?;
    get cachingConfig(): AppsyncResolverCachingConfig[] | undefined;
    set cachingConfig(value: AppsyncResolverCachingConfig[] | undefined);
    private _pipelineConfig?;
    get pipelineConfig(): AppsyncResolverPipelineConfig[] | undefined;
    set pipelineConfig(value: AppsyncResolverPipelineConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
