import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AthenaDatabaseConfig extends TerraformMetaArguments {
    readonly bucket: string;
    readonly forceDestroy?: boolean;
    readonly name: string;
    /** encryption_configuration block */
    readonly encryptionConfiguration?: AthenaDatabaseEncryptionConfiguration[];
}
export interface AthenaDatabaseEncryptionConfiguration {
    readonly encryptionOption: string;
    readonly kmsKey?: string;
}
export declare class AthenaDatabase extends TerraformResource {
    constructor(scope: Construct, id: string, config: AthenaDatabaseConfig);
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    private _forceDestroy?;
    get forceDestroy(): boolean | undefined;
    set forceDestroy(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _encryptionConfiguration?;
    get encryptionConfiguration(): AthenaDatabaseEncryptionConfiguration[] | undefined;
    set encryptionConfiguration(value: AthenaDatabaseEncryptionConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
