import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AthenaWorkgroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly forceDestroy?: boolean;
    readonly name: string;
    readonly state?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** configuration block */
    readonly configuration?: AthenaWorkgroupConfiguration[];
}
export interface AthenaWorkgroupConfigurationResultConfigurationEncryptionConfiguration {
    readonly encryptionOption?: string;
    readonly kmsKeyArn?: string;
}
export interface AthenaWorkgroupConfigurationResultConfiguration {
    readonly outputLocation?: string;
    /** encryption_configuration block */
    readonly encryptionConfiguration?: AthenaWorkgroupConfigurationResultConfigurationEncryptionConfiguration[];
}
export interface AthenaWorkgroupConfiguration {
    readonly bytesScannedCutoffPerQuery?: number;
    readonly enforceWorkgroupConfiguration?: boolean;
    readonly publishCloudwatchMetricsEnabled?: boolean;
    /** result_configuration block */
    readonly resultConfiguration?: AthenaWorkgroupConfigurationResultConfiguration[];
}
export declare class AthenaWorkgroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: AthenaWorkgroupConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _forceDestroy?;
    get forceDestroy(): boolean | undefined;
    set forceDestroy(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _configuration?;
    get configuration(): AthenaWorkgroupConfiguration[] | undefined;
    set configuration(value: AthenaWorkgroupConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
