import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AutoscalingGroupConfig extends TerraformMetaArguments {
    readonly availabilityZones?: string[];
    readonly defaultCooldown?: number;
    readonly desiredCapacity?: number;
    readonly enabledMetrics?: string[];
    readonly forceDelete?: boolean;
    readonly healthCheckGracePeriod?: number;
    readonly healthCheckType?: string;
    readonly launchConfiguration?: string;
    readonly loadBalancers?: string[];
    readonly maxInstanceLifetime?: number;
    readonly maxSize: number;
    readonly metricsGranularity?: string;
    readonly minElbCapacity?: number;
    readonly minSize: number;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly placementGroup?: string;
    readonly protectFromScaleIn?: boolean;
    readonly serviceLinkedRoleArn?: string;
    readonly suspendedProcesses?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly targetGroupArns?: string[];
    readonly terminationPolicies?: string[];
    readonly vpcZoneIdentifier?: string[];
    readonly waitForCapacityTimeout?: string;
    readonly waitForElbCapacity?: number;
    /** initial_lifecycle_hook block */
    readonly initialLifecycleHook?: AutoscalingGroupInitialLifecycleHook[];
    /** launch_template block */
    readonly launchTemplate?: AutoscalingGroupLaunchTemplate[];
    /** mixed_instances_policy block */
    readonly mixedInstancesPolicy?: AutoscalingGroupMixedInstancesPolicy[];
    /** tag block */
    readonly tag?: AutoscalingGroupTag[];
    /** timeouts block */
    readonly timeouts?: AutoscalingGroupTimeouts;
}
export interface AutoscalingGroupInitialLifecycleHook {
    readonly defaultResult?: string;
    readonly heartbeatTimeout?: number;
    readonly lifecycleTransition: string;
    readonly name: string;
    readonly notificationMetadata?: string;
    readonly notificationTargetArn?: string;
    readonly roleArn?: string;
}
export interface AutoscalingGroupLaunchTemplate {
    readonly id?: string;
    readonly name?: string;
    readonly version?: string;
}
export interface AutoscalingGroupMixedInstancesPolicyInstancesDistribution {
    readonly onDemandAllocationStrategy?: string;
    readonly onDemandBaseCapacity?: number;
    readonly onDemandPercentageAboveBaseCapacity?: number;
    readonly spotAllocationStrategy?: string;
    readonly spotInstancePools?: number;
    readonly spotMaxPrice?: string;
}
export interface AutoscalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification {
    readonly launchTemplateId?: string;
    readonly launchTemplateName?: string;
    readonly version?: string;
}
export interface AutoscalingGroupMixedInstancesPolicyLaunchTemplateOverride {
    readonly instanceType?: string;
    readonly weightedCapacity?: string;
}
export interface AutoscalingGroupMixedInstancesPolicyLaunchTemplate {
    /** launch_template_specification block */
    readonly launchTemplateSpecification: AutoscalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification[];
    /** override block */
    readonly override?: AutoscalingGroupMixedInstancesPolicyLaunchTemplateOverride[];
}
export interface AutoscalingGroupMixedInstancesPolicy {
    /** instances_distribution block */
    readonly instancesDistribution?: AutoscalingGroupMixedInstancesPolicyInstancesDistribution[];
    /** launch_template block */
    readonly launchTemplate: AutoscalingGroupMixedInstancesPolicyLaunchTemplate[];
}
export interface AutoscalingGroupTag {
    readonly key: string;
    readonly propagateAtLaunch: boolean;
    readonly value: string;
}
export interface AutoscalingGroupTimeouts {
    readonly delete?: string;
}
export declare class AutoscalingGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: AutoscalingGroupConfig);
    get arn(): string;
    private _availabilityZones?;
    get availabilityZones(): string[] | undefined;
    set availabilityZones(value: string[] | undefined);
    private _defaultCooldown?;
    get defaultCooldown(): number | undefined;
    set defaultCooldown(value: number | undefined);
    private _desiredCapacity?;
    get desiredCapacity(): number | undefined;
    set desiredCapacity(value: number | undefined);
    private _enabledMetrics?;
    get enabledMetrics(): string[] | undefined;
    set enabledMetrics(value: string[] | undefined);
    private _forceDelete?;
    get forceDelete(): boolean | undefined;
    set forceDelete(value: boolean | undefined);
    private _healthCheckGracePeriod?;
    get healthCheckGracePeriod(): number | undefined;
    set healthCheckGracePeriod(value: number | undefined);
    private _healthCheckType?;
    get healthCheckType(): string | undefined;
    set healthCheckType(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _launchConfiguration?;
    get launchConfiguration(): string | undefined;
    set launchConfiguration(value: string | undefined);
    private _loadBalancers?;
    get loadBalancers(): string[] | undefined;
    set loadBalancers(value: string[] | undefined);
    private _maxInstanceLifetime?;
    get maxInstanceLifetime(): number | undefined;
    set maxInstanceLifetime(value: number | undefined);
    private _maxSize;
    get maxSize(): number;
    set maxSize(value: number);
    private _metricsGranularity?;
    get metricsGranularity(): string | undefined;
    set metricsGranularity(value: string | undefined);
    private _minElbCapacity?;
    get minElbCapacity(): number | undefined;
    set minElbCapacity(value: number | undefined);
    private _minSize;
    get minSize(): number;
    set minSize(value: number);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _placementGroup?;
    get placementGroup(): string | undefined;
    set placementGroup(value: string | undefined);
    private _protectFromScaleIn?;
    get protectFromScaleIn(): boolean | undefined;
    set protectFromScaleIn(value: boolean | undefined);
    private _serviceLinkedRoleArn?;
    get serviceLinkedRoleArn(): string | undefined;
    set serviceLinkedRoleArn(value: string | undefined);
    private _suspendedProcesses?;
    get suspendedProcesses(): string[] | undefined;
    set suspendedProcesses(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _targetGroupArns?;
    get targetGroupArns(): string[] | undefined;
    set targetGroupArns(value: string[] | undefined);
    private _terminationPolicies?;
    get terminationPolicies(): string[] | undefined;
    set terminationPolicies(value: string[] | undefined);
    private _vpcZoneIdentifier?;
    get vpcZoneIdentifier(): string[] | undefined;
    set vpcZoneIdentifier(value: string[] | undefined);
    private _waitForCapacityTimeout?;
    get waitForCapacityTimeout(): string | undefined;
    set waitForCapacityTimeout(value: string | undefined);
    private _waitForElbCapacity?;
    get waitForElbCapacity(): number | undefined;
    set waitForElbCapacity(value: number | undefined);
    private _initialLifecycleHook?;
    get initialLifecycleHook(): AutoscalingGroupInitialLifecycleHook[] | undefined;
    set initialLifecycleHook(value: AutoscalingGroupInitialLifecycleHook[] | undefined);
    private _launchTemplate?;
    get launchTemplate(): AutoscalingGroupLaunchTemplate[] | undefined;
    set launchTemplate(value: AutoscalingGroupLaunchTemplate[] | undefined);
    private _mixedInstancesPolicy?;
    get mixedInstancesPolicy(): AutoscalingGroupMixedInstancesPolicy[] | undefined;
    set mixedInstancesPolicy(value: AutoscalingGroupMixedInstancesPolicy[] | undefined);
    private _tag?;
    get tag(): AutoscalingGroupTag[] | undefined;
    set tag(value: AutoscalingGroupTag[] | undefined);
    private _timeouts?;
    get timeouts(): AutoscalingGroupTimeouts | undefined;
    set timeouts(value: AutoscalingGroupTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
