"use strict";
// https://www.terraform.io/docs/providers/aws/r/autoscaling_group.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoscalingGroup = void 0;
const cdktf_1 = require("cdktf");
// Resource
class AutoscalingGroup extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_autoscaling_group',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._availabilityZones = config.availabilityZones;
        this._defaultCooldown = config.defaultCooldown;
        this._desiredCapacity = config.desiredCapacity;
        this._enabledMetrics = config.enabledMetrics;
        this._forceDelete = config.forceDelete;
        this._healthCheckGracePeriod = config.healthCheckGracePeriod;
        this._healthCheckType = config.healthCheckType;
        this._launchConfiguration = config.launchConfiguration;
        this._loadBalancers = config.loadBalancers;
        this._maxInstanceLifetime = config.maxInstanceLifetime;
        this._maxSize = config.maxSize;
        this._metricsGranularity = config.metricsGranularity;
        this._minElbCapacity = config.minElbCapacity;
        this._minSize = config.minSize;
        this._name = config.name;
        this._namePrefix = config.namePrefix;
        this._placementGroup = config.placementGroup;
        this._protectFromScaleIn = config.protectFromScaleIn;
        this._serviceLinkedRoleArn = config.serviceLinkedRoleArn;
        this._suspendedProcesses = config.suspendedProcesses;
        this._tags = config.tags;
        this._targetGroupArns = config.targetGroupArns;
        this._terminationPolicies = config.terminationPolicies;
        this._vpcZoneIdentifier = config.vpcZoneIdentifier;
        this._waitForCapacityTimeout = config.waitForCapacityTimeout;
        this._waitForElbCapacity = config.waitForElbCapacity;
        this._initialLifecycleHook = config.initialLifecycleHook;
        this._launchTemplate = config.launchTemplate;
        this._mixedInstancesPolicy = config.mixedInstancesPolicy;
        this._tag = config.tag;
        this._timeouts = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get availabilityZones() {
        var _a;
        return (_a = this._availabilityZones) !== null && _a !== void 0 ? _a : this.getListAttribute('availability_zones');
    }
    set availabilityZones(value) {
        this._availabilityZones = value;
    }
    get defaultCooldown() {
        var _a;
        return (_a = this._defaultCooldown) !== null && _a !== void 0 ? _a : this.getNumberAttribute('default_cooldown');
    }
    set defaultCooldown(value) {
        this._defaultCooldown = value;
    }
    get desiredCapacity() {
        var _a;
        return (_a = this._desiredCapacity) !== null && _a !== void 0 ? _a : this.getNumberAttribute('desired_capacity');
    }
    set desiredCapacity(value) {
        this._desiredCapacity = value;
    }
    get enabledMetrics() {
        return this._enabledMetrics;
    }
    set enabledMetrics(value) {
        this._enabledMetrics = value;
    }
    get forceDelete() {
        return this._forceDelete;
    }
    set forceDelete(value) {
        this._forceDelete = value;
    }
    get healthCheckGracePeriod() {
        return this._healthCheckGracePeriod;
    }
    set healthCheckGracePeriod(value) {
        this._healthCheckGracePeriod = value;
    }
    get healthCheckType() {
        var _a;
        return (_a = this._healthCheckType) !== null && _a !== void 0 ? _a : this.getStringAttribute('health_check_type');
    }
    set healthCheckType(value) {
        this._healthCheckType = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get launchConfiguration() {
        return this._launchConfiguration;
    }
    set launchConfiguration(value) {
        this._launchConfiguration = value;
    }
    get loadBalancers() {
        var _a;
        return (_a = this._loadBalancers) !== null && _a !== void 0 ? _a : this.getListAttribute('load_balancers');
    }
    set loadBalancers(value) {
        this._loadBalancers = value;
    }
    get maxInstanceLifetime() {
        return this._maxInstanceLifetime;
    }
    set maxInstanceLifetime(value) {
        this._maxInstanceLifetime = value;
    }
    get maxSize() {
        return this._maxSize;
    }
    set maxSize(value) {
        this._maxSize = value;
    }
    get metricsGranularity() {
        return this._metricsGranularity;
    }
    set metricsGranularity(value) {
        this._metricsGranularity = value;
    }
    get minElbCapacity() {
        return this._minElbCapacity;
    }
    set minElbCapacity(value) {
        this._minElbCapacity = value;
    }
    get minSize() {
        return this._minSize;
    }
    set minSize(value) {
        this._minSize = value;
    }
    get name() {
        var _a;
        return (_a = this._name) !== null && _a !== void 0 ? _a : this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    get namePrefix() {
        return this._namePrefix;
    }
    set namePrefix(value) {
        this._namePrefix = value;
    }
    get placementGroup() {
        return this._placementGroup;
    }
    set placementGroup(value) {
        this._placementGroup = value;
    }
    get protectFromScaleIn() {
        return this._protectFromScaleIn;
    }
    set protectFromScaleIn(value) {
        this._protectFromScaleIn = value;
    }
    get serviceLinkedRoleArn() {
        var _a;
        return (_a = this._serviceLinkedRoleArn) !== null && _a !== void 0 ? _a : this.getStringAttribute('service_linked_role_arn');
    }
    set serviceLinkedRoleArn(value) {
        this._serviceLinkedRoleArn = value;
    }
    get suspendedProcesses() {
        return this._suspendedProcesses;
    }
    set suspendedProcesses(value) {
        this._suspendedProcesses = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get targetGroupArns() {
        var _a;
        return (_a = this._targetGroupArns) !== null && _a !== void 0 ? _a : this.getListAttribute('target_group_arns');
    }
    set targetGroupArns(value) {
        this._targetGroupArns = value;
    }
    get terminationPolicies() {
        return this._terminationPolicies;
    }
    set terminationPolicies(value) {
        this._terminationPolicies = value;
    }
    get vpcZoneIdentifier() {
        var _a;
        return (_a = this._vpcZoneIdentifier) !== null && _a !== void 0 ? _a : this.getListAttribute('vpc_zone_identifier');
    }
    set vpcZoneIdentifier(value) {
        this._vpcZoneIdentifier = value;
    }
    get waitForCapacityTimeout() {
        return this._waitForCapacityTimeout;
    }
    set waitForCapacityTimeout(value) {
        this._waitForCapacityTimeout = value;
    }
    get waitForElbCapacity() {
        return this._waitForElbCapacity;
    }
    set waitForElbCapacity(value) {
        this._waitForElbCapacity = value;
    }
    get initialLifecycleHook() {
        return this._initialLifecycleHook;
    }
    set initialLifecycleHook(value) {
        this._initialLifecycleHook = value;
    }
    get launchTemplate() {
        return this._launchTemplate;
    }
    set launchTemplate(value) {
        this._launchTemplate = value;
    }
    get mixedInstancesPolicy() {
        return this._mixedInstancesPolicy;
    }
    set mixedInstancesPolicy(value) {
        this._mixedInstancesPolicy = value;
    }
    get tag() {
        return this._tag;
    }
    set tag(value) {
        this._tag = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            availability_zones: this._availabilityZones,
            default_cooldown: this._defaultCooldown,
            desired_capacity: this._desiredCapacity,
            enabled_metrics: this._enabledMetrics,
            force_delete: this._forceDelete,
            health_check_grace_period: this._healthCheckGracePeriod,
            health_check_type: this._healthCheckType,
            launch_configuration: this._launchConfiguration,
            load_balancers: this._loadBalancers,
            max_instance_lifetime: this._maxInstanceLifetime,
            max_size: this._maxSize,
            metrics_granularity: this._metricsGranularity,
            min_elb_capacity: this._minElbCapacity,
            min_size: this._minSize,
            name: this._name,
            name_prefix: this._namePrefix,
            placement_group: this._placementGroup,
            protect_from_scale_in: this._protectFromScaleIn,
            service_linked_role_arn: this._serviceLinkedRoleArn,
            suspended_processes: this._suspendedProcesses,
            tags: this._tags,
            target_group_arns: this._targetGroupArns,
            termination_policies: this._terminationPolicies,
            vpc_zone_identifier: this._vpcZoneIdentifier,
            wait_for_capacity_timeout: this._waitForCapacityTimeout,
            wait_for_elb_capacity: this._waitForElbCapacity,
            initial_lifecycle_hook: this._initialLifecycleHook,
            launch_template: this._launchTemplate,
            mixed_instances_policy: this._mixedInstancesPolicy,
            tag: this._tag,
            timeouts: this._timeouts,
        };
    }
}
exports.AutoscalingGroup = AutoscalingGroup;
//# sourceMappingURL=data:application/json;base64,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