import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AutoscalingLifecycleHookConfig extends TerraformMetaArguments {
    readonly autoscalingGroupName: string;
    readonly defaultResult?: string;
    readonly heartbeatTimeout?: number;
    readonly lifecycleTransition: string;
    readonly name: string;
    readonly notificationMetadata?: string;
    readonly notificationTargetArn?: string;
    readonly roleArn?: string;
}
export declare class AutoscalingLifecycleHook extends TerraformResource {
    constructor(scope: Construct, id: string, config: AutoscalingLifecycleHookConfig);
    private _autoscalingGroupName;
    get autoscalingGroupName(): string;
    set autoscalingGroupName(value: string);
    private _defaultResult?;
    get defaultResult(): string | undefined;
    set defaultResult(value: string | undefined);
    private _heartbeatTimeout?;
    get heartbeatTimeout(): number | undefined;
    set heartbeatTimeout(value: number | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _lifecycleTransition;
    get lifecycleTransition(): string;
    set lifecycleTransition(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _notificationMetadata?;
    get notificationMetadata(): string | undefined;
    set notificationMetadata(value: string | undefined);
    private _notificationTargetArn?;
    get notificationTargetArn(): string | undefined;
    set notificationTargetArn(value: string | undefined);
    private _roleArn?;
    get roleArn(): string | undefined;
    set roleArn(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
