"use strict";
// https://www.terraform.io/docs/providers/aws/r/autoscaling_lifecycle_hook.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoscalingLifecycleHook = void 0;
const cdktf_1 = require("cdktf");
// Resource
class AutoscalingLifecycleHook extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_autoscaling_lifecycle_hook',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._autoscalingGroupName = config.autoscalingGroupName;
        this._defaultResult = config.defaultResult;
        this._heartbeatTimeout = config.heartbeatTimeout;
        this._lifecycleTransition = config.lifecycleTransition;
        this._name = config.name;
        this._notificationMetadata = config.notificationMetadata;
        this._notificationTargetArn = config.notificationTargetArn;
        this._roleArn = config.roleArn;
    }
    get autoscalingGroupName() {
        return this._autoscalingGroupName;
    }
    set autoscalingGroupName(value) {
        this._autoscalingGroupName = value;
    }
    get defaultResult() {
        var _a;
        return (_a = this._defaultResult) !== null && _a !== void 0 ? _a : this.getStringAttribute('default_result');
    }
    set defaultResult(value) {
        this._defaultResult = value;
    }
    get heartbeatTimeout() {
        return this._heartbeatTimeout;
    }
    set heartbeatTimeout(value) {
        this._heartbeatTimeout = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get lifecycleTransition() {
        return this._lifecycleTransition;
    }
    set lifecycleTransition(value) {
        this._lifecycleTransition = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get notificationMetadata() {
        return this._notificationMetadata;
    }
    set notificationMetadata(value) {
        this._notificationMetadata = value;
    }
    get notificationTargetArn() {
        return this._notificationTargetArn;
    }
    set notificationTargetArn(value) {
        this._notificationTargetArn = value;
    }
    get roleArn() {
        return this._roleArn;
    }
    set roleArn(value) {
        this._roleArn = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            autoscaling_group_name: this._autoscalingGroupName,
            default_result: this._defaultResult,
            heartbeat_timeout: this._heartbeatTimeout,
            lifecycle_transition: this._lifecycleTransition,
            name: this._name,
            notification_metadata: this._notificationMetadata,
            notification_target_arn: this._notificationTargetArn,
            role_arn: this._roleArn,
        };
    }
}
exports.AutoscalingLifecycleHook = AutoscalingLifecycleHook;
//# sourceMappingURL=data:application/json;base64,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