import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AutoscalingPolicyConfig extends TerraformMetaArguments {
    readonly adjustmentType?: string;
    readonly autoscalingGroupName: string;
    readonly cooldown?: number;
    readonly estimatedInstanceWarmup?: number;
    readonly metricAggregationType?: string;
    readonly minAdjustmentMagnitude?: number;
    readonly minAdjustmentStep?: number;
    readonly name: string;
    readonly policyType?: string;
    readonly scalingAdjustment?: number;
    /** step_adjustment block */
    readonly stepAdjustment?: AutoscalingPolicyStepAdjustment[];
    /** target_tracking_configuration block */
    readonly targetTrackingConfiguration?: AutoscalingPolicyTargetTrackingConfiguration[];
}
export interface AutoscalingPolicyStepAdjustment {
    readonly metricIntervalLowerBound?: string;
    readonly metricIntervalUpperBound?: string;
    readonly scalingAdjustment: number;
}
export interface AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension {
    readonly name: string;
    readonly value: string;
}
export interface AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecification {
    readonly metricName: string;
    readonly namespace: string;
    readonly statistic: string;
    readonly unit?: string;
    /** metric_dimension block */
    readonly metricDimension?: AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension[];
}
export interface AutoscalingPolicyTargetTrackingConfigurationPredefinedMetricSpecification {
    readonly predefinedMetricType: string;
    readonly resourceLabel?: string;
}
export interface AutoscalingPolicyTargetTrackingConfiguration {
    readonly disableScaleIn?: boolean;
    readonly targetValue: number;
    /** customized_metric_specification block */
    readonly customizedMetricSpecification?: AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecification[];
    /** predefined_metric_specification block */
    readonly predefinedMetricSpecification?: AutoscalingPolicyTargetTrackingConfigurationPredefinedMetricSpecification[];
}
export declare class AutoscalingPolicy extends TerraformResource {
    constructor(scope: Construct, id: string, config: AutoscalingPolicyConfig);
    private _adjustmentType?;
    get adjustmentType(): string | undefined;
    set adjustmentType(value: string | undefined);
    get arn(): string;
    private _autoscalingGroupName;
    get autoscalingGroupName(): string;
    set autoscalingGroupName(value: string);
    private _cooldown?;
    get cooldown(): number | undefined;
    set cooldown(value: number | undefined);
    private _estimatedInstanceWarmup?;
    get estimatedInstanceWarmup(): number | undefined;
    set estimatedInstanceWarmup(value: number | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricAggregationType?;
    get metricAggregationType(): string | undefined;
    set metricAggregationType(value: string | undefined);
    private _minAdjustmentMagnitude?;
    get minAdjustmentMagnitude(): number | undefined;
    set minAdjustmentMagnitude(value: number | undefined);
    private _minAdjustmentStep?;
    get minAdjustmentStep(): number | undefined;
    set minAdjustmentStep(value: number | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _policyType?;
    get policyType(): string | undefined;
    set policyType(value: string | undefined);
    private _scalingAdjustment?;
    get scalingAdjustment(): number | undefined;
    set scalingAdjustment(value: number | undefined);
    private _stepAdjustment?;
    get stepAdjustment(): AutoscalingPolicyStepAdjustment[] | undefined;
    set stepAdjustment(value: AutoscalingPolicyStepAdjustment[] | undefined);
    private _targetTrackingConfiguration?;
    get targetTrackingConfiguration(): AutoscalingPolicyTargetTrackingConfiguration[] | undefined;
    set targetTrackingConfiguration(value: AutoscalingPolicyTargetTrackingConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
