"use strict";
// https://www.terraform.io/docs/providers/aws/r/autoscaling_policy.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoscalingPolicy = void 0;
const cdktf_1 = require("cdktf");
// Resource
class AutoscalingPolicy extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_autoscaling_policy',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._adjustmentType = config.adjustmentType;
        this._autoscalingGroupName = config.autoscalingGroupName;
        this._cooldown = config.cooldown;
        this._estimatedInstanceWarmup = config.estimatedInstanceWarmup;
        this._metricAggregationType = config.metricAggregationType;
        this._minAdjustmentMagnitude = config.minAdjustmentMagnitude;
        this._minAdjustmentStep = config.minAdjustmentStep;
        this._name = config.name;
        this._policyType = config.policyType;
        this._scalingAdjustment = config.scalingAdjustment;
        this._stepAdjustment = config.stepAdjustment;
        this._targetTrackingConfiguration = config.targetTrackingConfiguration;
    }
    get adjustmentType() {
        return this._adjustmentType;
    }
    set adjustmentType(value) {
        this._adjustmentType = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get autoscalingGroupName() {
        return this._autoscalingGroupName;
    }
    set autoscalingGroupName(value) {
        this._autoscalingGroupName = value;
    }
    get cooldown() {
        return this._cooldown;
    }
    set cooldown(value) {
        this._cooldown = value;
    }
    get estimatedInstanceWarmup() {
        return this._estimatedInstanceWarmup;
    }
    set estimatedInstanceWarmup(value) {
        this._estimatedInstanceWarmup = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get metricAggregationType() {
        var _a;
        return (_a = this._metricAggregationType) !== null && _a !== void 0 ? _a : this.getStringAttribute('metric_aggregation_type');
    }
    set metricAggregationType(value) {
        this._metricAggregationType = value;
    }
    get minAdjustmentMagnitude() {
        return this._minAdjustmentMagnitude;
    }
    set minAdjustmentMagnitude(value) {
        this._minAdjustmentMagnitude = value;
    }
    get minAdjustmentStep() {
        return this._minAdjustmentStep;
    }
    set minAdjustmentStep(value) {
        this._minAdjustmentStep = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get policyType() {
        return this._policyType;
    }
    set policyType(value) {
        this._policyType = value;
    }
    get scalingAdjustment() {
        return this._scalingAdjustment;
    }
    set scalingAdjustment(value) {
        this._scalingAdjustment = value;
    }
    get stepAdjustment() {
        return this._stepAdjustment;
    }
    set stepAdjustment(value) {
        this._stepAdjustment = value;
    }
    get targetTrackingConfiguration() {
        return this._targetTrackingConfiguration;
    }
    set targetTrackingConfiguration(value) {
        this._targetTrackingConfiguration = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            adjustment_type: this._adjustmentType,
            autoscaling_group_name: this._autoscalingGroupName,
            cooldown: this._cooldown,
            estimated_instance_warmup: this._estimatedInstanceWarmup,
            metric_aggregation_type: this._metricAggregationType,
            min_adjustment_magnitude: this._minAdjustmentMagnitude,
            min_adjustment_step: this._minAdjustmentStep,
            name: this._name,
            policy_type: this._policyType,
            scaling_adjustment: this._scalingAdjustment,
            step_adjustment: this._stepAdjustment,
            target_tracking_configuration: this._targetTrackingConfiguration,
        };
    }
}
exports.AutoscalingPolicy = AutoscalingPolicy;
//# sourceMappingURL=data:application/json;base64,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