import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface AutoscalingScheduleConfig extends TerraformMetaArguments {
    readonly autoscalingGroupName: string;
    readonly desiredCapacity?: number;
    readonly endTime?: string;
    readonly maxSize?: number;
    readonly minSize?: number;
    readonly recurrence?: string;
    readonly scheduledActionName: string;
    readonly startTime?: string;
}
export declare class AutoscalingSchedule extends TerraformResource {
    constructor(scope: Construct, id: string, config: AutoscalingScheduleConfig);
    get arn(): string;
    private _autoscalingGroupName;
    get autoscalingGroupName(): string;
    set autoscalingGroupName(value: string);
    private _desiredCapacity?;
    get desiredCapacity(): number | undefined;
    set desiredCapacity(value: number | undefined);
    private _endTime?;
    get endTime(): string | undefined;
    set endTime(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _maxSize?;
    get maxSize(): number | undefined;
    set maxSize(value: number | undefined);
    private _minSize?;
    get minSize(): number | undefined;
    set minSize(value: number | undefined);
    private _recurrence?;
    get recurrence(): string | undefined;
    set recurrence(value: string | undefined);
    private _scheduledActionName;
    get scheduledActionName(): string;
    set scheduledActionName(value: string);
    private _startTime?;
    get startTime(): string | undefined;
    set startTime(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
