"use strict";
// https://www.terraform.io/docs/providers/aws/r/aws_provider.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsProvider = void 0;
const cdktf_1 = require("cdktf");
// Resource
class AwsProvider extends cdktf_1.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersionConstraint: '~> 2.0'
            }
        });
        this._accessKey = config.accessKey;
        this._allowedAccountIds = config.allowedAccountIds;
        this._forbiddenAccountIds = config.forbiddenAccountIds;
        this._insecure = config.insecure;
        this._maxRetries = config.maxRetries;
        this._profile = config.profile;
        this._region = config.region;
        this._s3ForcePathStyle = config.s3ForcePathStyle;
        this._secretKey = config.secretKey;
        this._sharedCredentialsFile = config.sharedCredentialsFile;
        this._skipCredentialsValidation = config.skipCredentialsValidation;
        this._skipGetEc2Platforms = config.skipGetEc2Platforms;
        this._skipMetadataApiCheck = config.skipMetadataApiCheck;
        this._skipRegionValidation = config.skipRegionValidation;
        this._skipRequestingAccountId = config.skipRequestingAccountId;
        this._token = config.token;
        this._alias = config.alias;
        this._assumeRole = config.assumeRole;
        this._endpoints = config.endpoints;
        this._ignoreTags = config.ignoreTags;
    }
    get accessKey() {
        return this._accessKey;
    }
    set accessKey(value) {
        this._accessKey = value;
    }
    get allowedAccountIds() {
        return this._allowedAccountIds;
    }
    set allowedAccountIds(value) {
        this._allowedAccountIds = value;
    }
    get forbiddenAccountIds() {
        return this._forbiddenAccountIds;
    }
    set forbiddenAccountIds(value) {
        this._forbiddenAccountIds = value;
    }
    get insecure() {
        return this._insecure;
    }
    set insecure(value) {
        this._insecure = value;
    }
    get maxRetries() {
        return this._maxRetries;
    }
    set maxRetries(value) {
        this._maxRetries = value;
    }
    get profile() {
        return this._profile;
    }
    set profile(value) {
        this._profile = value;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    get s3ForcePathStyle() {
        return this._s3ForcePathStyle;
    }
    set s3ForcePathStyle(value) {
        this._s3ForcePathStyle = value;
    }
    get secretKey() {
        return this._secretKey;
    }
    set secretKey(value) {
        this._secretKey = value;
    }
    get sharedCredentialsFile() {
        return this._sharedCredentialsFile;
    }
    set sharedCredentialsFile(value) {
        this._sharedCredentialsFile = value;
    }
    get skipCredentialsValidation() {
        return this._skipCredentialsValidation;
    }
    set skipCredentialsValidation(value) {
        this._skipCredentialsValidation = value;
    }
    get skipGetEc2Platforms() {
        return this._skipGetEc2Platforms;
    }
    set skipGetEc2Platforms(value) {
        this._skipGetEc2Platforms = value;
    }
    get skipMetadataApiCheck() {
        return this._skipMetadataApiCheck;
    }
    set skipMetadataApiCheck(value) {
        this._skipMetadataApiCheck = value;
    }
    get skipRegionValidation() {
        return this._skipRegionValidation;
    }
    set skipRegionValidation(value) {
        this._skipRegionValidation = value;
    }
    get skipRequestingAccountId() {
        return this._skipRequestingAccountId;
    }
    set skipRequestingAccountId(value) {
        this._skipRequestingAccountId = value;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    get assumeRole() {
        return this._assumeRole;
    }
    set assumeRole(value) {
        this._assumeRole = value;
    }
    get endpoints() {
        return this._endpoints;
    }
    set endpoints(value) {
        this._endpoints = value;
    }
    get ignoreTags() {
        return this._ignoreTags;
    }
    set ignoreTags(value) {
        this._ignoreTags = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_key: this._accessKey,
            allowed_account_ids: this._allowedAccountIds,
            forbidden_account_ids: this._forbiddenAccountIds,
            insecure: this._insecure,
            max_retries: this._maxRetries,
            profile: this._profile,
            region: this._region,
            s3_force_path_style: this._s3ForcePathStyle,
            secret_key: this._secretKey,
            shared_credentials_file: this._sharedCredentialsFile,
            skip_credentials_validation: this._skipCredentialsValidation,
            skip_get_ec2_platforms: this._skipGetEc2Platforms,
            skip_metadata_api_check: this._skipMetadataApiCheck,
            skip_region_validation: this._skipRegionValidation,
            skip_requesting_account_id: this._skipRequestingAccountId,
            token: this._token,
            alias: this._alias,
            assume_role: this._assumeRole,
            endpoints: this._endpoints,
            ignore_tags: this._ignoreTags,
        };
    }
}
exports.AwsProvider = AwsProvider;
//# sourceMappingURL=data:application/json;base64,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