import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface BackupPlanConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** rule block */
    readonly rule: BackupPlanRule[];
}
export interface BackupPlanRuleCopyActionLifecycle {
    readonly coldStorageAfter?: number;
    readonly deleteAfter?: number;
}
export interface BackupPlanRuleCopyAction {
    readonly destinationVaultArn: string;
    /** lifecycle block */
    readonly lifecycle?: BackupPlanRuleCopyActionLifecycle[];
}
export interface BackupPlanRuleLifecycle {
    readonly coldStorageAfter?: number;
    readonly deleteAfter?: number;
}
export interface BackupPlanRule {
    readonly completionWindow?: number;
    readonly recoveryPointTags?: {
        [key: string]: string;
    };
    readonly ruleName: string;
    readonly schedule?: string;
    readonly startWindow?: number;
    readonly targetVaultName: string;
    /** copy_action block */
    readonly copyAction?: BackupPlanRuleCopyAction[];
    /** lifecycle block */
    readonly lifecycle?: BackupPlanRuleLifecycle[];
}
export declare class BackupPlan extends TerraformResource {
    constructor(scope: Construct, id: string, config: BackupPlanConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get version(): string;
    private _rule;
    get rule(): BackupPlanRule[];
    set rule(value: BackupPlanRule[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
