import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface BackupSelectionConfig extends TerraformMetaArguments {
    readonly iamRoleArn: string;
    readonly name: string;
    readonly planId: string;
    readonly resources?: string[];
    /** selection_tag block */
    readonly selectionTag?: BackupSelectionSelectionTag[];
}
export interface BackupSelectionSelectionTag {
    readonly key: string;
    readonly type: string;
    readonly value: string;
}
export declare class BackupSelection extends TerraformResource {
    constructor(scope: Construct, id: string, config: BackupSelectionConfig);
    private _iamRoleArn;
    get iamRoleArn(): string;
    set iamRoleArn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _planId;
    get planId(): string;
    set planId(value: string);
    private _resources?;
    get resources(): string[] | undefined;
    set resources(value: string[] | undefined);
    private _selectionTag?;
    get selectionTag(): BackupSelectionSelectionTag[] | undefined;
    set selectionTag(value: BackupSelectionSelectionTag[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
