import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface BackupVaultConfig extends TerraformMetaArguments {
    readonly kmsKeyArn?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class BackupVault extends TerraformResource {
    constructor(scope: Construct, id: string, config: BackupVaultConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string | undefined;
    set kmsKeyArn(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get recoveryPoints(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
