import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface BatchComputeEnvironmentConfig extends TerraformMetaArguments {
    readonly computeEnvironmentName?: string;
    readonly computeEnvironmentNamePrefix?: string;
    readonly serviceRole: string;
    readonly state?: string;
    readonly type: string;
    /** compute_resources block */
    readonly computeResources?: BatchComputeEnvironmentComputeResources[];
}
export interface BatchComputeEnvironmentComputeResourcesLaunchTemplate {
    readonly launchTemplateId?: string;
    readonly launchTemplateName?: string;
    readonly version?: string;
}
export interface BatchComputeEnvironmentComputeResources {
    readonly allocationStrategy?: string;
    readonly bidPercentage?: number;
    readonly desiredVcpus?: number;
    readonly ec2KeyPair?: string;
    readonly imageId?: string;
    readonly instanceRole: string;
    readonly instanceType: string[];
    readonly maxVcpus: number;
    readonly minVcpus: number;
    readonly securityGroupIds: string[];
    readonly spotIamFleetRole?: string;
    readonly subnets: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly type: string;
    /** launch_template block */
    readonly launchTemplate?: BatchComputeEnvironmentComputeResourcesLaunchTemplate[];
}
export declare class BatchComputeEnvironment extends TerraformResource {
    constructor(scope: Construct, id: string, config: BatchComputeEnvironmentConfig);
    get arn(): string;
    private _computeEnvironmentName?;
    get computeEnvironmentName(): string | undefined;
    set computeEnvironmentName(value: string | undefined);
    private _computeEnvironmentNamePrefix?;
    get computeEnvironmentNamePrefix(): string | undefined;
    set computeEnvironmentNamePrefix(value: string | undefined);
    get eccClusterArn(): string;
    get ecsClusterArn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _serviceRole;
    get serviceRole(): string;
    set serviceRole(value: string);
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    get status(): string;
    get statusReason(): string;
    private _type;
    get type(): string;
    set type(value: string);
    private _computeResources?;
    get computeResources(): BatchComputeEnvironmentComputeResources[] | undefined;
    set computeResources(value: BatchComputeEnvironmentComputeResources[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
