import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface BatchJobDefinitionConfig extends TerraformMetaArguments {
    readonly containerProperties?: string;
    readonly name: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly type: string;
    /** retry_strategy block */
    readonly retryStrategy?: BatchJobDefinitionRetryStrategy[];
    /** timeout block */
    readonly timeout?: BatchJobDefinitionTimeout[];
}
export interface BatchJobDefinitionRetryStrategy {
    readonly attempts?: number;
}
export interface BatchJobDefinitionTimeout {
    readonly attemptDurationSeconds?: number;
}
export declare class BatchJobDefinition extends TerraformResource {
    constructor(scope: Construct, id: string, config: BatchJobDefinitionConfig);
    get arn(): string;
    private _containerProperties?;
    get containerProperties(): string | undefined;
    set containerProperties(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    } | undefined;
    set parameters(value: {
        [key: string]: string;
    } | undefined);
    get revision(): number;
    private _type;
    get type(): string;
    set type(value: string);
    private _retryStrategy?;
    get retryStrategy(): BatchJobDefinitionRetryStrategy[] | undefined;
    set retryStrategy(value: BatchJobDefinitionRetryStrategy[] | undefined);
    private _timeout?;
    get timeout(): BatchJobDefinitionTimeout[] | undefined;
    set timeout(value: BatchJobDefinitionTimeout[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
