import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface BudgetsBudgetConfig extends TerraformMetaArguments {
    readonly accountId?: string;
    readonly budgetType: string;
    readonly costFilters?: {
        [key: string]: string;
    };
    readonly limitAmount: string;
    readonly limitUnit: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly timePeriodEnd?: string;
    readonly timePeriodStart: string;
    readonly timeUnit: string;
    /** cost_types block */
    readonly costTypes?: BudgetsBudgetCostTypes[];
    /** notification block */
    readonly notification?: BudgetsBudgetNotification[];
}
export interface BudgetsBudgetCostTypes {
    readonly includeCredit?: boolean;
    readonly includeDiscount?: boolean;
    readonly includeOtherSubscription?: boolean;
    readonly includeRecurring?: boolean;
    readonly includeRefund?: boolean;
    readonly includeSubscription?: boolean;
    readonly includeSupport?: boolean;
    readonly includeTax?: boolean;
    readonly includeUpfront?: boolean;
    readonly useAmortized?: boolean;
    readonly useBlended?: boolean;
}
export interface BudgetsBudgetNotification {
    readonly comparisonOperator: string;
    readonly notificationType: string;
    readonly subscriberEmailAddresses?: string[];
    readonly subscriberSnsTopicArns?: string[];
    readonly threshold: number;
    readonly thresholdType: string;
}
export declare class BudgetsBudget extends TerraformResource {
    constructor(scope: Construct, id: string, config: BudgetsBudgetConfig);
    private _accountId?;
    get accountId(): string | undefined;
    set accountId(value: string | undefined);
    private _budgetType;
    get budgetType(): string;
    set budgetType(value: string);
    private _costFilters?;
    get costFilters(): {
        [key: string]: string;
    } | undefined;
    set costFilters(value: {
        [key: string]: string;
    } | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _limitAmount;
    get limitAmount(): string;
    set limitAmount(value: string);
    private _limitUnit;
    get limitUnit(): string;
    set limitUnit(value: string);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _timePeriodEnd?;
    get timePeriodEnd(): string | undefined;
    set timePeriodEnd(value: string | undefined);
    private _timePeriodStart;
    get timePeriodStart(): string;
    set timePeriodStart(value: string);
    private _timeUnit;
    get timeUnit(): string;
    set timeUnit(value: string);
    private _costTypes?;
    get costTypes(): BudgetsBudgetCostTypes[] | undefined;
    set costTypes(value: BudgetsBudgetCostTypes[] | undefined);
    private _notification?;
    get notification(): BudgetsBudgetNotification[] | undefined;
    set notification(value: BudgetsBudgetNotification[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
