import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Cloud9EnvironmentEc2Config extends TerraformMetaArguments {
    readonly automaticStopTimeMinutes?: number;
    readonly description?: string;
    readonly instanceType: string;
    readonly name: string;
    readonly ownerArn?: string;
    readonly subnetId?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class Cloud9EnvironmentEc2 extends TerraformResource {
    constructor(scope: Construct, id: string, config: Cloud9EnvironmentEc2Config);
    get arn(): string;
    private _automaticStopTimeMinutes?;
    get automaticStopTimeMinutes(): number | undefined;
    set automaticStopTimeMinutes(value: number | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceType;
    get instanceType(): string;
    set instanceType(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _ownerArn?;
    get ownerArn(): string | undefined;
    set ownerArn(value: string | undefined);
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get type(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
