import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudformationStackSetInstanceConfig extends TerraformMetaArguments {
    readonly accountId?: string;
    readonly parameterOverrides?: {
        [key: string]: string;
    };
    readonly region?: string;
    readonly retainStack?: boolean;
    readonly stackSetName: string;
    /** timeouts block */
    readonly timeouts?: CloudformationStackSetInstanceTimeouts;
}
export interface CloudformationStackSetInstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class CloudformationStackSetInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudformationStackSetInstanceConfig);
    private _accountId?;
    get accountId(): string | undefined;
    set accountId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _parameterOverrides?;
    get parameterOverrides(): {
        [key: string]: string;
    } | undefined;
    set parameterOverrides(value: {
        [key: string]: string;
    } | undefined);
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    private _retainStack?;
    get retainStack(): boolean | undefined;
    set retainStack(value: boolean | undefined);
    get stackId(): string;
    private _stackSetName;
    get stackSetName(): string;
    set stackSetName(value: string);
    private _timeouts?;
    get timeouts(): CloudformationStackSetInstanceTimeouts | undefined;
    set timeouts(value: CloudformationStackSetInstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
