import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudformationStackSetConfig extends TerraformMetaArguments {
    readonly administrationRoleArn: string;
    readonly capabilities?: string[];
    readonly description?: string;
    readonly executionRoleName?: string;
    readonly name: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly tags?: {
        [key: string]: string;
    };
    readonly templateBody?: string;
    readonly templateUrl?: string;
    /** timeouts block */
    readonly timeouts?: CloudformationStackSetTimeouts;
}
export interface CloudformationStackSetTimeouts {
    readonly update?: string;
}
export declare class CloudformationStackSet extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudformationStackSetConfig);
    private _administrationRoleArn;
    get administrationRoleArn(): string;
    set administrationRoleArn(value: string);
    get arn(): string;
    private _capabilities?;
    get capabilities(): string[] | undefined;
    set capabilities(value: string[] | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _executionRoleName?;
    get executionRoleName(): string | undefined;
    set executionRoleName(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    } | undefined;
    set parameters(value: {
        [key: string]: string;
    } | undefined);
    get stackSetId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _templateBody?;
    get templateBody(): string | undefined;
    set templateBody(value: string | undefined);
    private _templateUrl?;
    get templateUrl(): string | undefined;
    set templateUrl(value: string | undefined);
    private _timeouts?;
    get timeouts(): CloudformationStackSetTimeouts | undefined;
    set timeouts(value: CloudformationStackSetTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
